/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jgroups;

import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.jgroups.CamelJGroupsReceiver;
import org.apache.camel.component.jgroups.JGroupsEndpoint;
import org.apache.camel.support.DefaultConsumer;
import org.jgroups.JChannel;
import org.jgroups.Receiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGroupsConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(JGroupsConsumer.class);
    private final JChannel channel;
    private final String clusterName;
    private final CamelJGroupsReceiver receiver;
    private final JGroupsEndpoint endpoint;

    public JGroupsConsumer(JGroupsEndpoint endpoint, Processor processor, JChannel channel, String clusterName) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.channel = channel;
        this.clusterName = clusterName;
        this.receiver = new CamelJGroupsReceiver(endpoint, processor);
    }

    protected void doStart() throws Exception {
        super.doStart();
        LOG.debug("Connecting receiver: {} to the cluster: {}.", (Object)this.receiver, (Object)this.clusterName);
        this.channel.setReceiver((Receiver)this.receiver);
        this.endpoint.connect();
    }

    protected void doStop() throws Exception {
        LOG.debug("Closing connection to cluster: {} from receiver: {}.", (Object)this.clusterName, (Object)this.receiver);
        this.channel.setReceiver(null);
        this.endpoint.disconnect();
        super.doStop();
    }
}

