/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jdbc;

import javax.sql.DataSource;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.jdbc.JdbcProducer;
import org.apache.camel.impl.DefaultEndpoint;

public class JdbcEndpoint
extends DefaultEndpoint {
    private int readSize;
    private DataSource dataSource;

    public JdbcEndpoint() {
    }

    public JdbcEndpoint(String endpointUri, Component component, DataSource dataSource) {
        super(endpointUri, component);
        this.dataSource = dataSource;
    }

    public boolean isSingleton() {
        return true;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Not supported");
    }

    public Producer createProducer() throws Exception {
        return new JdbcProducer(this, this.dataSource, this.readSize);
    }

    public int getReadSize() {
        return this.readSize;
    }

    public void setReadSize(int readSize) {
        this.readSize = readSize;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected String createEndpointUri() {
        return "jdbc";
    }
}

