/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcache.processor.idempotent;

import javax.cache.Cache;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.jcache.JCacheConfiguration;
import org.apache.camel.component.jcache.JCacheHelper;
import org.apache.camel.component.jcache.JCacheManager;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="bean", description="Idempotent repository that uses JCache to store message ids.", annotations={"interfaceName=org.apache.camel.spi.IdempotentRepository"})
@Configurer(metadataOnly=true)
@ManagedResource(description="JCache based message id repository")
public class JCacheIdempotentRepository
extends ServiceSupport
implements CamelContextAware,
IdempotentRepository {
    private CamelContext camelContext;
    private Cache<String, Boolean> cache;
    private JCacheManager<String, Boolean> cacheManager;
    @Metadata(description="Configuration for JCache")
    private JCacheConfiguration configuration = new JCacheConfiguration();

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public JCacheConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(JCacheConfiguration configuration) {
        this.configuration = configuration;
    }

    public Cache<String, Boolean> getCache() {
        return this.cache;
    }

    public void setCache(Cache<String, Boolean> cache) {
        this.cache = cache;
    }

    @ManagedOperation(description="Adds the key to the store")
    public boolean add(String key) {
        return this.cache.putIfAbsent((Object)key, (Object)true);
    }

    @ManagedOperation(description="Does the store contain the given key")
    public boolean contains(String key) {
        return this.cache.containsKey((Object)key);
    }

    @ManagedOperation(description="Remove the key from the store")
    public boolean remove(String key) {
        return this.cache.remove((Object)key);
    }

    @ManagedOperation(description="Clear the store")
    public void clear() {
        this.cache.clear();
    }

    public void setCacheName(String cacheName) {
        this.configuration.setCacheName(cacheName);
    }

    @ManagedAttribute(description="The processor name")
    public String getCacheName() {
        return this.configuration.getCacheName();
    }

    public boolean confirm(String key) {
        return this.cache.replace((Object)key, (Object)false, (Object)true);
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.camelContext, (String)"camelContext");
        ObjectHelper.notNull((Object)this.configuration, (String)"configuration");
        if (this.cache != null) {
            this.cacheManager = new JCacheManager<String, Boolean>(this.cache);
        } else {
            this.cacheManager = JCacheHelper.createManager(this.getCamelContext(), this.configuration);
            this.cache = this.cacheManager.getCache();
        }
    }

    protected void doStop() throws Exception {
        if (this.cacheManager != null) {
            this.cacheManager.close();
        }
    }
}

