/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxb;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.RestBindingJaxbDataFormatFactory;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.PropertyBindingSupport;

@JdkService(value="rest-binding-jaxb-dataformat-factory")
public class JaxbRestBindingJaxbDataFormatFactory
implements RestBindingJaxbDataFormatFactory {
    public void setupJaxb(CamelContext camelContext, RestConfiguration config, String type, Class<?> typeClass, String outType, Class<?> outTypeClass, DataFormat jaxb, DataFormat outJaxb) throws Exception {
        PropertyConfigurer configurer = PluginHelper.getConfigurerResolver((CamelContext)camelContext).resolvePropertyConfigurer("jaxb-dataformat-configurer", camelContext);
        if (configurer == null) {
            throw new IllegalStateException("Cannot find configurer for dataformat: jaxb");
        }
        PropertyBindingSupport.Builder builder = PropertyBindingSupport.build().withCamelContext(camelContext).withConfigurer(configurer).withTarget((Object)jaxb);
        String typeName = JaxbRestBindingJaxbDataFormatFactory.getTypeName(type, typeClass);
        if (typeName != null) {
            builder.withProperty("contextPath", (Object)typeName);
            builder.withProperty("contextPathIsClassName", (Object)"true");
        }
        this.setAdditionalConfiguration(config, "xml.in.", builder);
        builder.bind();
        PropertyBindingSupport.Builder outBuilder = PropertyBindingSupport.build().withCamelContext(camelContext).withConfigurer(configurer).withTarget((Object)outJaxb);
        String outTypeName = JaxbRestBindingJaxbDataFormatFactory.getOutTypeName(outType, outTypeClass, typeName);
        if (outTypeName != null) {
            outBuilder.withProperty("contextPath", (Object)outTypeName);
            outBuilder.withProperty("contextPathIsClassName", (Object)"true");
        }
        this.setAdditionalConfiguration(config, "xml.out.", outBuilder);
        outBuilder.bind();
    }

    private static String getOutTypeName(String outType, Class<?> outTypeClass, String typeName) {
        String outTypeName = null;
        if (outTypeClass != null) {
            outTypeName = outTypeClass.isArray() ? outTypeClass.getComponentType().getName() : outTypeClass.getName();
        } else if (outType != null) {
            outTypeName = outType.endsWith("[]") ? outType.substring(0, outType.length() - 2) : outType;
        } else if (typeName != null) {
            outTypeName = typeName;
        }
        return outTypeName;
    }

    private static String getTypeName(String type, Class<?> typeClass) {
        String typeName = null;
        if (typeClass != null) {
            typeName = typeClass.isArray() ? typeClass.getComponentType().getName() : typeClass.getName();
        } else if (type != null) {
            typeName = type.endsWith("[]") ? type.substring(0, type.length() - 2) : type;
        }
        return typeName;
    }

    private void setAdditionalConfiguration(RestConfiguration config, String prefix, PropertyBindingSupport.Builder builder) {
        if (config.getDataFormatProperties() != null && !config.getDataFormatProperties().isEmpty()) {
            HashMap copy = new HashMap();
            for (Map.Entry entry : config.getDataFormatProperties().entrySet()) {
                String key = (String)entry.getKey();
                boolean known = this.isKeyKnownPrefix(key);
                String copyKey = known ? key.substring(prefix.length()) : key;
                if (known && !key.startsWith(prefix)) continue;
                copy.put(copyKey, entry.getValue());
            }
            builder.withProperties(copy);
        }
    }

    private boolean isKeyKnownPrefix(String key) {
        return key.startsWith("json.in.") || key.startsWith("json.out.") || key.startsWith("xml.in.") || key.startsWith("xml.out.");
    }
}

