/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.irc;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.irc.IrcEndpoint;
import org.apache.camel.component.irc.IrcErrorLogger;
import org.apache.camel.impl.DefaultProducer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.schwering.irc.lib.IRCConnection;
import org.schwering.irc.lib.IRCEventListener;

public class IrcProducer
extends DefaultProducer {
    public static final String[] COMMANDS = new String[]{"AWAY", "INVITE", "ISON", "JOIN", "KICK", "LIST", "NAMES", "PRIVMSG", "MODE", "NICK", "NOTICE", "PART", "PONG", "QUIT", "TOPIC", "WHO", "WHOIS", "WHOWAS", "USERHOST"};
    private static final transient Log LOG = LogFactory.getLog(IrcProducer.class);
    private IRCConnection connection;
    private IrcEndpoint endpoint;
    private IRCEventListener ircErrorLogger;

    public IrcProducer(IrcEndpoint endpoint, IRCConnection connection) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.connection = connection;
    }

    public void process(Exchange exchange) throws Exception {
        String msg = (String)exchange.getIn().getBody(String.class);
        if (this.isMessageACommand(msg)) {
            this.connection.send(msg);
        } else {
            String target = this.endpoint.getConfiguration().getTarget();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Sending to: " + target + " message: " + msg));
            }
            this.connection.doPrivmsg(target, msg);
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.ircErrorLogger = this.createIrcErrorLogger();
        this.connection.addIRCEventListener(this.ircErrorLogger);
        String target = this.endpoint.getConfiguration().getTarget();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Joining: " + target));
        }
        this.connection.doJoin(target);
    }

    protected void doStop() throws Exception {
        if (this.connection != null) {
            this.connection.removeIRCEventListener(this.ircErrorLogger);
        }
        super.doStop();
    }

    protected boolean isMessageACommand(String msg) {
        for (String command : COMMANDS) {
            if (!msg.startsWith(command)) continue;
            return true;
        }
        return false;
    }

    protected IRCEventListener createIrcErrorLogger() {
        return new IrcErrorLogger(LOG);
    }
}

