/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.component.http.HttpClientConfigurer;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;

public class CompositeHttpConfigurer
extends ServiceSupport
implements HttpClientConfigurer {
    private final List<HttpClientConfigurer> configurers = new ArrayList<HttpClientConfigurer>();

    public void addConfigurer(HttpClientConfigurer configurer) {
        if (configurer != null) {
            this.configurers.add(configurer);
        }
    }

    @Override
    public void configureHttpClient(HttpClientBuilder clientBuilder) {
        for (HttpClientConfigurer configurer : this.configurers) {
            configurer.configureHttpClient(clientBuilder);
        }
    }

    public static CompositeHttpConfigurer combineConfigurers(HttpClientConfigurer oldConfigurer, HttpClientConfigurer newConfigurer) {
        if (oldConfigurer instanceof CompositeHttpConfigurer) {
            CompositeHttpConfigurer compositeHttpConfigurer = (CompositeHttpConfigurer)oldConfigurer;
            compositeHttpConfigurer.addConfigurer(newConfigurer);
            return compositeHttpConfigurer;
        }
        CompositeHttpConfigurer answer = new CompositeHttpConfigurer();
        answer.addConfigurer(newConfigurer);
        answer.addConfigurer(oldConfigurer);
        return answer;
    }

    protected void doStart() throws Exception {
        super.doStart();
        ServiceHelper.startService(this.configurers);
    }

    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService(this.configurers);
    }
}

