/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.net.URI;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.HeaderFilterStrategyAware;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.component.http.BasicAuthenticationHttpClientConfigurer;
import org.apache.camel.component.http.HttpBinding;
import org.apache.camel.component.http.HttpClientConfigurer;
import org.apache.camel.component.http.HttpConsumer;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.component.http.HttpExchange;
import org.apache.camel.component.http.HttpHeaderFilterStrategy;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.URISupport;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpClientParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpComponent
extends DefaultComponent<HttpExchange>
implements HeaderFilterStrategyAware {
    protected HttpClientConfigurer httpClientConfigurer;
    protected HttpConnectionManager httpConnectionManager = new MultiThreadedHttpConnectionManager();
    protected HeaderFilterStrategy headerFilterStrategy;
    protected HttpBinding httpBinding;

    public HttpComponent() {
        this.setHeaderFilterStrategy((HeaderFilterStrategy)new HttpHeaderFilterStrategy());
    }

    public void connect(HttpConsumer consumer) throws Exception {
    }

    public void disconnect(HttpConsumer consumer) throws Exception {
    }

    protected void configureParameters(Map parameters) {
        String ref = (String)this.getAndRemoveParameter(parameters, "httpBindingRef", String.class);
        if (ref != null) {
            this.httpBinding = (HttpBinding)CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)ref, HttpBinding.class);
        }
        String username = (String)this.getAndRemoveParameter(parameters, "username", String.class);
        String password = (String)this.getAndRemoveParameter(parameters, "password", String.class);
        if (username != null && password != null) {
            this.httpClientConfigurer = new BasicAuthenticationHttpClientConfigurer(username, password);
        }
        if ((ref = (String)this.getAndRemoveParameter(parameters, "httpClientConfigurerRef", String.class)) != null) {
            this.httpClientConfigurer = (HttpClientConfigurer)CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)ref, HttpClientConfigurer.class);
        }
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        HttpClientParams params = new HttpClientParams();
        IntrospectionSupport.setProperties((Object)params, (Map)parameters, (String)"httpClient.");
        this.configureParameters(parameters);
        URI httpUri = URISupport.createRemainingURI((URI)new URI(uri), (Map)parameters);
        uri = httpUri.toString();
        String part = httpUri.getSchemeSpecificPart();
        if (part != null && ((part = part.toLowerCase()).startsWith("//http//") || part.startsWith("//https//"))) {
            throw new ResolveEndpointFailedException(uri, "The uri part is not configured correctly. You have duplicated the http(s) protocol.");
        }
        HttpEndpoint endpoint = new HttpEndpoint(uri, this, httpUri, params, this.httpConnectionManager, this.httpClientConfigurer);
        if (this.httpBinding != null) {
            endpoint.setBinding(this.httpBinding);
        }
        return endpoint;
    }

    protected boolean useIntrospectionOnEndpoint() {
        return false;
    }

    public HttpClientConfigurer getHttpClientConfigurer() {
        return this.httpClientConfigurer;
    }

    public void setHttpClientConfigurer(HttpClientConfigurer httpClientConfigurer) {
        this.httpClientConfigurer = httpClientConfigurer;
    }

    public HttpConnectionManager getHttpConnectionManager() {
        return this.httpConnectionManager;
    }

    public void setHttpConnectionManager(HttpConnectionManager httpConnectionManager) {
        this.httpConnectionManager = httpConnectionManager;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
    }

    public HttpBinding getHttpBinding() {
        return this.httpBinding;
    }

    public void setHttpBinding(HttpBinding httpBinding) {
        this.httpBinding = httpBinding;
    }
}

