/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.Component;
import org.apache.camel.ExchangePattern;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Producer;
import org.apache.camel.component.http.HttpBinding;
import org.apache.camel.component.http.HttpComponent;
import org.apache.camel.component.http.HttpConsumer;
import org.apache.camel.component.http.HttpExchange;
import org.apache.camel.component.http.HttpPollingConsumer;
import org.apache.camel.component.http.HttpProducer;
import org.apache.camel.impl.DefaultPollingEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpEndpoint
extends DefaultPollingEndpoint<HttpExchange> {
    private HttpBinding binding;
    private HttpComponent component;
    private URI httpUri;

    public HttpEndpoint(String endPointURI, HttpComponent component, URI httpURI) throws URISyntaxException {
        super(endPointURI, (Component)component);
        this.component = component;
        this.httpUri = httpURI;
    }

    public Producer<HttpExchange> createProducer() throws Exception {
        return new HttpProducer(this);
    }

    public PollingConsumer<HttpExchange> createPollingConsumer() throws Exception {
        return new HttpPollingConsumer(this);
    }

    public HttpExchange createExchange(ExchangePattern pattern) {
        return new HttpExchange(this, pattern);
    }

    public HttpExchange createExchange(HttpServletRequest request, HttpServletResponse response) {
        return new HttpExchange(this, request, response);
    }

    public HttpBinding getBinding() {
        if (this.binding == null) {
            this.binding = new HttpBinding();
        }
        return this.binding;
    }

    public void setBinding(HttpBinding binding) {
        this.binding = binding;
    }

    public boolean isSingleton() {
        return true;
    }

    public void connect(HttpConsumer consumer) throws Exception {
        this.component.connect(consumer);
    }

    public void disconnect(HttpConsumer consumer) throws Exception {
        this.component.disconnect(consumer);
    }

    public String getPath() {
        return this.httpUri.getPath();
    }

    public int getPort() {
        if (this.httpUri.getPort() == -1) {
            if ("https".equals(this.getProtocol())) {
                return 443;
            }
            return 80;
        }
        return this.httpUri.getPort();
    }

    public String getProtocol() {
        return this.httpUri.getScheme();
    }

    public URI getHttpUri() {
        return this.httpUri;
    }
}

