/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.graphql;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.graphql.GraphqlEndpoint;
import org.apache.camel.http.base.HttpHelper;
import org.apache.camel.http.base.HttpOperationFailedException;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.http.HttpUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.json.JsonObject;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphqlProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(GraphqlProducer.class);
    private static final Integer OK_RESPONSE_CODE = 200;
    private static final String OK_STATUS_RANGE = "200-299";
    private HttpClient httpClient;
    private boolean closeHttpClient;

    public GraphqlProducer(GraphqlEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.httpClient = this.getEndpoint().getHttpClient();
        if (this.httpClient == null) {
            this.httpClient = this.getEndpoint().createHttpClient();
            this.closeHttpClient = true;
        }
    }

    protected void doStop() throws Exception {
        HttpClient httpClient;
        if (this.closeHttpClient && (httpClient = this.httpClient) instanceof CloseableHttpClient) {
            CloseableHttpClient chc = (CloseableHttpClient)httpClient;
            IOHelper.close((Closeable)chc);
        }
    }

    public GraphqlEndpoint getEndpoint() {
        return (GraphqlEndpoint)super.getEndpoint();
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            URI httpUri = this.getEndpoint().getHttpUri();
            String requestBody = GraphqlProducer.buildRequestBody(this.getQuery(exchange), this.getEndpoint().getOperationName(), this.getVariables(exchange));
            StringEntity requestEntity = new StringEntity(requestBody, ContentType.APPLICATION_JSON);
            HttpPost httpPost = new HttpPost(httpUri);
            httpPost.setHeader("Content-Type", (Object)"application/json");
            httpPost.setHeader("Accept", (Object)"application/json");
            httpPost.setHeader("Accept-Encoding", (Object)"gzip");
            httpPost.setEntity((HttpEntity)requestEntity);
            this.populateRequestHeaders(exchange, httpPost);
            this.httpClient.execute((ClassicHttpRequest)httpPost, httpResponse -> {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Finished executing http: {} method: {}", (Object)httpUri, (Object)"POST");
                }
                int responseCode = httpResponse.getCode();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Http responseCode: {}", (Object)responseCode);
                }
                if (!this.getEndpoint().isThrowExceptionOnFailure()) {
                    this.populateResponse(exchange, httpResponse, this.getEndpoint().getHeaderFilterStrategy(), responseCode);
                } else {
                    boolean ok = HttpHelper.isStatusCodeOk((int)responseCode, (String)OK_STATUS_RANGE);
                    if (ok) {
                        this.populateResponse(exchange, httpResponse, this.getEndpoint().getHeaderFilterStrategy(), responseCode);
                    } else {
                        GraphqlProducer.populateResponseCode(exchange.getMessage(), httpResponse, responseCode);
                        exchange.setException((Throwable)this.populateHttpOperationFailedException(exchange, httpResponse, responseCode));
                    }
                }
                return null;
            });
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        callback.done(true);
        return true;
    }

    private void populateRequestHeaders(Exchange exchange, HttpPost httpRequest) {
        HeaderFilterStrategy strategy = this.getEndpoint().getHeaderFilterStrategy();
        TypeConverter tc = exchange.getContext().getTypeConverter();
        for (Map.Entry entry : exchange.getMessage().getHeaders().entrySet()) {
            Object headerValue;
            String key = (String)entry.getKey();
            boolean skip = this.getEndpoint().getQueryHeader() != null && key.equalsIgnoreCase(this.getEndpoint().getQueryHeader()) || this.getEndpoint().getVariablesHeader() != null && key.equalsIgnoreCase(this.getEndpoint().getVariablesHeader());
            if (skip || (headerValue = entry.getValue()) == null) continue;
            if (headerValue instanceof String || headerValue instanceof Integer || headerValue instanceof Long || headerValue instanceof Boolean || headerValue instanceof Date) {
                String value = headerValue.toString();
                if (strategy.applyFilterToCamelHeaders(key, (Object)value, exchange)) continue;
                httpRequest.addHeader(key, (Object)value);
                continue;
            }
            Iterator it = ObjectHelper.createIterator(headerValue, null, (boolean)true);
            HttpUtil.applyHeader((HeaderFilterStrategy)strategy, (Exchange)exchange, (Iterator)it, (TypeConverter)tc, (String)key, (multiValues, prev) -> GraphqlProducer.applyHeader((HttpUriRequest)httpRequest, key, multiValues, prev));
        }
    }

    private static void applyHeader(HttpUriRequest httpRequest, String key, List<String> multiValues, String prev) {
        if (multiValues != null) {
            String s = multiValues.size() > 1 ? multiValues.toString() : multiValues.get(0);
            httpRequest.addHeader(key, (Object)s);
        } else if (prev != null) {
            httpRequest.addHeader(key, (Object)prev);
        }
    }

    private static void populateResponseCode(Message message, ClassicHttpResponse httpResponse, int responseCode) {
        if (responseCode == 200) {
            message.setHeader("CamelHttpResponseCode", (Object)OK_RESPONSE_CODE);
        } else {
            message.setHeader("CamelHttpResponseCode", (Object)responseCode);
        }
        if (httpResponse.getReasonPhrase() != null) {
            message.setHeader("CamelHttpResponseText", (Object)httpResponse.getReasonPhrase());
        }
    }

    protected Exception populateHttpOperationFailedException(Exchange exchange, ClassicHttpResponse httpResponse, int responseCode) throws IOException, ParseException {
        String statusText = httpResponse.getReasonPhrase() != null ? httpResponse.getReasonPhrase() : null;
        Map<String, String> headers = GraphqlProducer.extractResponseHeaders(httpResponse.getHeaders());
        String responseBody = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
        String copy = null;
        if (responseBody != null) {
            copy = (String)exchange.getContext().getTypeConverter().convertTo(String.class, exchange, (Object)responseBody);
        }
        Header locationHeader = httpResponse.getFirstHeader("location");
        String uri = this.getEndpoint().getHttpUri().toString();
        HttpOperationFailedException answer = locationHeader != null && responseCode >= 300 && responseCode < 400 ? new HttpOperationFailedException(uri, responseCode, statusText, locationHeader.getValue(), headers, copy) : new HttpOperationFailedException(uri, responseCode, statusText, null, headers, copy);
        return answer;
    }

    protected void populateResponse(Exchange exchange, ClassicHttpResponse httpResponse, HeaderFilterStrategy strategy, int responseCode) throws IOException, ParseException {
        Message answer = exchange.getMessage();
        GraphqlProducer.populateResponseCode(answer, httpResponse, responseCode);
        String responseBody = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
        answer.setBody((Object)responseBody);
        boolean found = false;
        Iterator it = httpResponse.headerIterator();
        while (it.hasNext()) {
            Header header = (Header)it.next();
            String name = header.getName();
            String value = header.getValue();
            if (!found && name.equalsIgnoreCase("content-type")) {
                name = "Content-Type";
                exchange.setProperty(ExchangePropertyKey.CHARSET_NAME, (Object)IOHelper.getCharsetNameFromContentType((String)value));
                found = true;
            }
            Object extracted = HttpHelper.extractHttpParameterValue((String)value);
            if (strategy == null || strategy.applyFilterToExternalHeaders(name, extracted, exchange)) continue;
            HttpHelper.appendHeader((Map)answer.getHeaders(), (String)name, (Object)extracted);
        }
    }

    protected static Map<String, String> extractResponseHeaders(Header[] responseHeaders) {
        if (responseHeaders == null || responseHeaders.length == 0) {
            return Map.of();
        }
        HashMap<String, String> answer = new HashMap<String, String>();
        for (Header header : responseHeaders) {
            answer.put(header.getName(), header.getValue());
        }
        return answer;
    }

    protected static String buildRequestBody(String query, String operationName, JsonObject variables) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.put((Object)"query", (Object)query);
        jsonObject.put((Object)"operationName", (Object)operationName);
        jsonObject.put((Object)"variables", (Object)(variables != null ? variables : new JsonObject()));
        return jsonObject.toJson();
    }

    private String getQuery(Exchange exchange) throws InvalidPayloadException {
        String query = null;
        query = this.getEndpoint().getQuery() != null ? this.getEndpoint().getQuery() : (this.getEndpoint().getQueryHeader() != null ? (String)exchange.getIn().getHeader(this.getEndpoint().getQueryHeader(), String.class) : (String)exchange.getIn().getMandatoryBody(String.class));
        return query;
    }

    private JsonObject getVariables(Exchange exchange) {
        JsonObject variables = null;
        if (this.getEndpoint().getVariables() != null) {
            variables = this.getEndpoint().getVariables();
        } else if (this.getEndpoint().getVariablesHeader() != null) {
            variables = (JsonObject)exchange.getIn().getHeader(this.getEndpoint().getVariablesHeader(), JsonObject.class);
        } else if (exchange.getIn().getBody() instanceof JsonObject) {
            variables = (JsonObject)exchange.getIn().getBody(JsonObject.class);
        }
        return variables;
    }
}

