/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.graphql;

import java.net.URI;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.graphql.GraphqlEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.HeaderFilterStrategyComponent;
import org.apache.camel.util.URISupport;
import org.apache.hc.client5.http.classic.HttpClient;

@org.apache.camel.spi.annotations.Component(value="graphql")
public class GraphqlComponent
extends HeaderFilterStrategyComponent {
    @Metadata(label="advanced")
    private HttpClient httpClient;
    @Metadata(label="producer", defaultValue="true", description="Option to disable throwing the HttpOperationFailedException in case of failed responses from the remote server. This allows you to get all responses regardless of the HTTP status code.")
    private boolean throwExceptionOnFailure = true;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        GraphqlEndpoint endpoint = new GraphqlEndpoint(uri, (Component)this);
        endpoint.setHeaderFilterStrategy(this.getHeaderFilterStrategy());
        endpoint.setHttpClient(this.httpClient);
        endpoint.setThrowExceptionOnFailure(this.throwExceptionOnFailure);
        endpoint.setHttpUri(new URI(remaining));
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    protected void afterConfiguration(String uri, String remaining, Endpoint endpoint, Map<String, Object> parameters) throws Exception {
        GraphqlEndpoint graphqlEndpoint = (GraphqlEndpoint)endpoint;
        if (!parameters.isEmpty()) {
            URI httpUri = URISupport.createRemainingURI((URI)graphqlEndpoint.getHttpUri(), parameters);
            graphqlEndpoint.setHttpUri(httpUri);
        }
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public boolean isThrowExceptionOnFailure() {
        return this.throwExceptionOnFailure;
    }

    public void setThrowExceptionOnFailure(boolean throwExceptionOnFailure) {
        this.throwExceptionOnFailure = throwExceptionOnFailure;
    }
}

