/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.graphql;

import java.io.Closeable;
import java.net.URI;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.component.graphql.GraphqlEndpoint;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.json.JsonObject;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;

public class GraphqlProducer
extends DefaultAsyncProducer {
    private HttpClient httpClient;
    private boolean closeHttpClient;

    public GraphqlProducer(GraphqlEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.httpClient = this.getEndpoint().getHttpClient();
        if (this.httpClient == null) {
            this.httpClient = this.getEndpoint().createHttpClient();
            this.closeHttpClient = true;
        }
    }

    protected void doStop() throws Exception {
        HttpClient httpClient;
        if (this.closeHttpClient && (httpClient = this.httpClient) instanceof CloseableHttpClient) {
            CloseableHttpClient chc = (CloseableHttpClient)httpClient;
            IOHelper.close((Closeable)chc);
        }
    }

    public GraphqlEndpoint getEndpoint() {
        return (GraphqlEndpoint)super.getEndpoint();
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            URI httpUri = this.getEndpoint().getHttpUri();
            String requestBody = GraphqlProducer.buildRequestBody(this.getQuery(exchange), this.getEndpoint().getOperationName(), this.getVariables(exchange));
            StringEntity requestEntity = new StringEntity(requestBody, ContentType.APPLICATION_JSON);
            HttpPost httpPost = new HttpPost(httpUri);
            httpPost.setHeader("Accept", (Object)"application/json");
            httpPost.setHeader("Accept-Encoding", (Object)"gzip");
            httpPost.setEntity((HttpEntity)requestEntity);
            String responseContent = (String)this.httpClient.execute((ClassicHttpRequest)httpPost, response -> EntityUtils.toString((HttpEntity)response.getEntity()));
            exchange.getMessage().setBody((Object)responseContent);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        callback.done(true);
        return true;
    }

    protected static String buildRequestBody(String query, String operationName, JsonObject variables) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.put((Object)"query", (Object)query);
        jsonObject.put((Object)"operationName", (Object)operationName);
        jsonObject.put((Object)"variables", (Object)(variables != null ? variables : new JsonObject()));
        return jsonObject.toJson();
    }

    private String getQuery(Exchange exchange) throws InvalidPayloadException {
        String query = null;
        query = this.getEndpoint().getQuery() != null ? this.getEndpoint().getQuery() : (this.getEndpoint().getQueryHeader() != null ? (String)exchange.getIn().getHeader(this.getEndpoint().getQueryHeader(), String.class) : (String)exchange.getIn().getMandatoryBody(String.class));
        return query;
    }

    private JsonObject getVariables(Exchange exchange) {
        JsonObject variables = null;
        if (this.getEndpoint().getVariables() != null) {
            variables = this.getEndpoint().getVariables();
        } else if (this.getEndpoint().getVariablesHeader() != null) {
            variables = (JsonObject)exchange.getIn().getHeader(this.getEndpoint().getVariablesHeader(), JsonObject.class);
        } else if (exchange.getIn().getBody() instanceof JsonObject) {
            variables = (JsonObject)exchange.getIn().getBody(JsonObject.class);
        }
        return variables;
    }
}

