/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.sheets.stream;

import com.google.api.services.sheets.v4.Sheets;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.google.sheets.BatchGoogleSheetsClientFactory;
import org.apache.camel.component.google.sheets.GoogleSheetsClientFactory;
import org.apache.camel.component.google.sheets.stream.GoogleSheetsStreamConfiguration;
import org.apache.camel.component.google.sheets.stream.GoogleSheetsStreamEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.HealthCheckComponent;

@Metadata(label="verifiers", enums="parameters,connectivity")
@Component(value="google-sheets-stream")
public class GoogleSheetsStreamComponent
extends HealthCheckComponent {
    @Metadata
    private GoogleSheetsStreamConfiguration configuration = new GoogleSheetsStreamConfiguration();
    @Metadata(label="advanced")
    private Sheets client;
    @Metadata(label="advanced")
    private GoogleSheetsClientFactory clientFactory;

    public GoogleSheetsStreamComponent() {
        this(null);
    }

    public GoogleSheetsStreamComponent(CamelContext context) {
        super(context);
    }

    public Sheets getClient(GoogleSheetsStreamConfiguration config) {
        if (this.client == null) {
            if (config.getClientId() != null && config.getClientSecret() != null) {
                this.client = this.getClientFactory().makeClient(config.getClientId(), config.getClientSecret(), config.getScopesAsList(), config.getApplicationName(), config.getRefreshToken(), config.getAccessToken());
            } else if (config.getServiceAccountKey() != null) {
                this.client = this.getClientFactory().makeClient(this.getCamelContext(), config.getServiceAccountKey(), config.getScopesAsList(), config.getApplicationName(), config.getDelegate());
            } else {
                throw new IllegalArgumentException("(clientId and clientSecret) or serviceAccountKey are required to create Gmail client");
            }
        }
        return this.client;
    }

    public GoogleSheetsClientFactory getClientFactory() {
        if (this.clientFactory == null) {
            this.clientFactory = new BatchGoogleSheetsClientFactory();
        }
        return this.clientFactory;
    }

    public GoogleSheetsStreamConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(GoogleSheetsStreamConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setClientFactory(GoogleSheetsClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        GoogleSheetsStreamConfiguration configuration = this.configuration.copy();
        configuration.setSpreadsheetId(remaining);
        GoogleSheetsStreamEndpoint endpoint = new GoogleSheetsStreamEndpoint(uri, this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }
}

