/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.sheets.transform;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.camel.util.ObjectHelper;

public class CellCoordinate {
    private int rowIndex;
    private int columnIndex;

    CellCoordinate() {
    }

    public static CellCoordinate fromCellId(String cellId) {
        CellCoordinate coordinate = new CellCoordinate();
        if (cellId != null) {
            coordinate.setRowIndex(CellCoordinate.getRowIndex(cellId));
            coordinate.setColumnIndex(CellCoordinate.getColumnIndex(cellId));
        }
        return coordinate;
    }

    protected static int getColumnIndex(String cellId) {
        char[] characters = cellId.toCharArray();
        List chars = IntStream.range(0, characters.length).mapToObj(i -> Character.valueOf(characters[i])).filter(c -> !Character.isDigit(c.charValue())).map(Character::toUpperCase).map(Character::getNumericValue).collect(Collectors.toList());
        if (chars.size() > 1) {
            int index = 0;
            for (int i2 = 0; i2 < chars.size(); ++i2) {
                if (i2 == chars.size() - 1) {
                    index += (Integer)chars.get(i2) - Character.getNumericValue('A');
                    continue;
                }
                index += ((Integer)chars.get(i2) - Character.getNumericValue('A') + 1) * 26;
            }
            return index;
        }
        if (chars.size() == 1) {
            return (Integer)chars.get(0) - Character.getNumericValue('A');
        }
        return 0;
    }

    protected static int getRowIndex(String cellId) {
        char[] characters = cellId.toCharArray();
        String index = IntStream.range(0, characters.length).mapToObj(i -> Character.valueOf(characters[i])).filter(Character::isDigit).map(String::valueOf).collect(Collectors.joining());
        if (ObjectHelper.isNotEmpty((String)index)) {
            return Integer.parseInt(index) - 1;
        }
        return 0;
    }

    public static String getColumnName(int columnIndex) {
        int index;
        String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        StringBuilder columnName = new StringBuilder();
        int overflowIndex = -1;
        for (index = columnIndex; index > 25; index -= 26) {
            ++overflowIndex;
        }
        if (overflowIndex >= 0) {
            columnName.append(alphabet.toCharArray()[overflowIndex]);
        }
        columnName.append(alphabet.toCharArray()[index]);
        return columnName.toString();
    }

    public static String getColumnName(int columnIndex, int columnStartIndex, String ... columnNames) {
        String columnName = CellCoordinate.getColumnName(columnIndex);
        int index = columnStartIndex > 0 ? columnIndex % columnStartIndex : columnIndex;
        if (index < columnNames.length) {
            String name = columnNames[index];
            if (columnName.equals(name)) {
                return columnName;
            }
            return name;
        }
        return columnName;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public void setColumnIndex(int columnIndex) {
        this.columnIndex = columnIndex;
    }
}

