/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.pubsub.transform;

import java.util.Map;
import org.apache.camel.Message;
import org.apache.camel.cloudevents.CloudEvents;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.Transformer;

@DataTypeTransformer(name="google-pubsub:application-cloudevents", description="Adds CloudEvent headers to the Camel message with Google Pubsub Pulling information")
public class GooglePubsubCloudEventDataTypeTransformer
extends Transformer {
    public void transform(Message message, DataType fromType, DataType toType) {
        Map headers = message.getHeaders();
        CloudEvents cloudEvent = CloudEvents.v1_0;
        headers.putIfAbsent("CamelCloudEventID", message.getExchange().getExchangeId());
        headers.putIfAbsent("CamelCloudEventVersion", cloudEvent.version());
        headers.put("CamelCloudEventType", "org.apache.camel.event.google.pubsub.pull");
        if (message.getHeaders().containsKey("CamelGooglePubsubMsgAckId")) {
            headers.put("CamelCloudEventSource", "google.pubsub." + (String)message.getHeader("CamelGooglePubsubMsgAckId", String.class));
        }
        headers.put("CamelCloudEventSubject", message.getHeader("CamelGooglePubsubMessageId", String.class));
        headers.put("CamelCloudEventTime", cloudEvent.getEventTime(message.getExchange()));
        headers.put("Content-Type", "application/octet-stream");
    }
}

