/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.github.consumer;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.github.GitHubEndpoint;
import org.apache.camel.component.github.consumer.AbstractGitHubConsumer;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.RepositoryTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagConsumer
extends AbstractGitHubConsumer {
    private static final transient Logger LOG = LoggerFactory.getLogger(TagConsumer.class);
    private List<String> tagNames = new ArrayList<String>();

    public TagConsumer(GitHubEndpoint endpoint, Processor processor) throws Exception {
        super(endpoint, processor);
        LOG.info("GitHub TagConsumer: Indexing current tags...");
        List tags = this.getRepositoryService().getTags((IRepositoryIdProvider)this.getRepository());
        for (RepositoryTag tag : tags) {
            this.tagNames.add(tag.getName());
        }
    }

    @Override
    protected int poll() throws Exception {
        List tags = this.getRepositoryService().getTags((IRepositoryIdProvider)this.getRepository());
        ArrayDeque<RepositoryTag> newTags = new ArrayDeque<RepositoryTag>();
        for (RepositoryTag tag : tags) {
            if (this.tagNames.contains(tag.getName())) continue;
            newTags.push(tag);
            this.tagNames.add(tag.getName());
        }
        int counter = 0;
        while (!newTags.isEmpty()) {
            RepositoryTag newTag = (RepositoryTag)newTags.pop();
            Exchange e = this.createExchange(true);
            e.getIn().setBody((Object)newTag);
            this.getProcessor().process(e);
            ++counter;
        }
        return counter;
    }
}

