/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.git.consumer;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.git.GitEndpoint;
import org.apache.camel.component.git.consumer.AbstractGitConsumer;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.lib.Ref;

public class GitBranchConsumer
extends AbstractGitConsumer {
    private final List<String> branchesConsumed = new ArrayList<String>();

    public GitBranchConsumer(GitEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    protected int poll() throws Exception {
        ArrayDeque<Object> exchanges = new ArrayDeque<Object>();
        List call = this.getGit().branchList().setListMode(ListBranchCommand.ListMode.ALL).call();
        for (Ref ref : call) {
            if (this.branchesConsumed.contains(ref.getName())) continue;
            Exchange e = this.createExchange(true);
            e.getMessage().setBody((Object)ref.getName());
            e.getMessage().setHeader("CamelGitBranchName", (Object)ref.getName());
            e.getMessage().setHeader("CamelGitBranchLeaf", (Object)ref.getLeaf().getName());
            e.getMessage().setHeader("CamelGitBranchObjectId", (Object)ref.getObjectId().getName());
            exchanges.add(e);
        }
        return this.processBatch(exchanges);
    }

    @Override
    public Object onPreProcessed(Exchange exchange) {
        return exchange.getMessage().getHeader("CamelGitBranchName", String.class);
    }

    @Override
    public void onProcessed(Exchange exchange, Object value) {
        if (value != null) {
            this.branchesConsumed.add(value.toString());
        }
    }
}

