/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.flatpack;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import net.sf.flatpack.DataSet;
import net.sf.flatpack.DefaultParserFactory;
import net.sf.flatpack.Parser;
import net.sf.flatpack.ParserFactory;
import org.apache.camel.Exchange;
import org.apache.camel.component.flatpack.DataSetList;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.ObjectHelper;
import org.springframework.core.io.Resource;

public class FlatpackDataFormat
implements DataFormat {
    private char delimiter = (char)44;
    private char textQualifier = (char)34;
    private boolean ignoreFirstRecord = true;
    private Resource definition;
    private boolean fixed = false;
    private ParserFactory parserFactory = DefaultParserFactory.getInstance();

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        throw new UnsupportedOperationException("marshal() not implemented yet!");
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        InputStreamReader reader = new InputStreamReader(stream);
        Parser parser = this.createParser(exchange, reader);
        DataSet dataSet = parser.parse();
        return new DataSetList(dataSet);
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    public boolean isIgnoreFirstRecord() {
        return this.ignoreFirstRecord;
    }

    public void setIgnoreFirstRecord(boolean ignoreFirstRecord) {
        this.ignoreFirstRecord = ignoreFirstRecord;
    }

    public char getTextQualifier() {
        return this.textQualifier;
    }

    public void setTextQualifier(char textQualifier) {
        this.textQualifier = textQualifier;
    }

    public Resource getDefinition() {
        return this.definition;
    }

    public void setDefinition(Resource definition) {
        this.definition = definition;
    }

    public ParserFactory getParserFactory() {
        return this.parserFactory;
    }

    public void setParserFactory(ParserFactory parserFactory) {
        this.parserFactory = parserFactory;
    }

    protected Parser createParser(Exchange exchange, Reader bodyReader) throws IOException {
        if (this.isFixed()) {
            Resource resource = this.getDefinition();
            ObjectHelper.notNull((Object)resource, (String)"resource property");
            return this.getParserFactory().newFixedLengthParser((Reader)new InputStreamReader(resource.getInputStream()), bodyReader);
        }
        Resource resource = this.getDefinition();
        if (resource == null) {
            return this.getParserFactory().newDelimitedParser(bodyReader, this.delimiter, this.textQualifier);
        }
        return this.getParserFactory().newDelimitedParser((Reader)new InputStreamReader(resource.getInputStream()), bodyReader, this.delimiter, this.textQualifier, this.ignoreFirstRecord);
    }
}

