/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dropbox.integration.consumer;

import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.dropbox.DropboxConfiguration;
import org.apache.camel.component.dropbox.DropboxEndpoint;
import org.apache.camel.component.dropbox.core.DropboxAPIFacade;
import org.apache.camel.component.dropbox.dto.DropboxFileDownloadResult;
import org.apache.camel.component.dropbox.integration.consumer.DropboxScheduledPollConsumer;
import org.apache.camel.component.dropbox.util.DropboxConstants;

public class DropboxScheduledPollGetConsumer
extends DropboxScheduledPollConsumer {
    public DropboxScheduledPollGetConsumer(DropboxEndpoint endpoint, Processor processor, DropboxConfiguration configuration) {
        super(endpoint, processor, configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int poll() throws Exception {
        Exchange exchange = this.createExchange(false);
        try {
            DropboxFileDownloadResult result = new DropboxAPIFacade(this.configuration.getClient(), exchange).get(this.configuration.getRemotePath());
            Map<String, Object> map = result.getEntries();
            if (map.size() == 1) {
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    exchange.getIn().setHeader(DropboxConstants.DOWNLOADED_FILE, (Object)entry.getKey());
                    exchange.getIn().setBody(entry.getValue());
                }
            } else {
                StringBuilder pathsExtracted = new StringBuilder();
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    pathsExtracted.append(entry.getKey()).append("\n");
                }
                exchange.getIn().setHeader(DropboxConstants.DOWNLOADED_FILES, (Object)pathsExtracted.toString());
                exchange.getIn().setBody(map);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Downloaded: {}", (Object)result);
            }
            this.getProcessor().process(exchange);
            int n = 1;
            return n;
        }
        finally {
            if (exchange.getException() != null) {
                this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
            }
            this.releaseExchange(exchange, false);
        }
    }
}

