/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.direct;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.Endpoint;
import org.apache.camel.component.direct.DirectConsumer;
import org.apache.camel.component.direct.DirectEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.StopWatch;

@Component(value="direct")
public class DirectComponent
extends DefaultComponent {
    private final Lock consumersLock = new ReentrantLock();
    private final Condition consumersCondition = this.consumersLock.newCondition();
    private final Map<String, DirectConsumer> consumers = new HashMap<String, DirectConsumer>();
    private volatile int stateCounter;
    @Metadata(label="producer", defaultValue="true")
    private boolean block = true;
    @Metadata(label="producer", defaultValue="30000")
    private long timeout = 30000L;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        DirectEndpoint endpoint = new DirectEndpoint(uri, this);
        endpoint.setBlock(this.block);
        endpoint.setTimeout(this.timeout);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownService(this.consumers);
        this.consumers.clear();
        super.doShutdown();
    }

    public boolean isBlock() {
        return this.block;
    }

    public void setBlock(boolean block) {
        this.block = block;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    int getStateCounter() {
        return this.stateCounter;
    }

    public void addConsumer(String key, DirectConsumer consumer) {
        this.consumersLock.lock();
        try {
            if (this.consumers.putIfAbsent(key, consumer) != null) {
                throw new IllegalArgumentException("Cannot add a 2nd consumer to the same endpoint: " + key + ". DirectEndpoint only allows one consumer.");
            }
            ++this.stateCounter;
            this.consumersCondition.signalAll();
        }
        finally {
            this.consumersLock.unlock();
        }
    }

    public void removeConsumer(String key, DirectConsumer consumer) {
        this.consumersLock.lock();
        try {
            this.consumers.remove(key, (Object)consumer);
            ++this.stateCounter;
            this.consumersCondition.signalAll();
        }
        finally {
            this.consumersLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DirectConsumer getConsumer(String key, boolean block, long timeout) throws InterruptedException {
        this.consumersLock.lock();
        try {
            DirectConsumer answer = this.consumers.get(key);
            if (answer == null && block) {
                long rem;
                StopWatch watch = new StopWatch();
                while ((answer = this.consumers.get(key)) == null && (rem = timeout - watch.taken()) > 0L) {
                    this.consumersCondition.await(rem, TimeUnit.MILLISECONDS);
                }
            }
            DirectConsumer directConsumer = answer;
            return directConsumer;
        }
        finally {
            this.consumersLock.unlock();
        }
    }
}

