/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Service;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.ExceptionHelper;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;

@DevConsole(name="receive", displayName="Camel Receive", description="Consume messages from endpoints")
@Configurer(bootstrap=true, extended=true)
public class ReceiveDevConsole
extends AbstractDevConsole {
    @Metadata(defaultValue="100", description="Maximum capacity of last number of messages to capture (capacity must be between 50 and 1000)")
    private int capacity = 100;
    @Metadata(defaultValue="32768", label="advanced", description="To limit the message body to a maximum size in the received message. Use 0 or negative value to use unlimited size.")
    private int bodyMaxChars = 32768;
    @Metadata(defaultValue="true", label="advanced", description="Whether all received messages should be removed when dumping. By default, the messages are removed, which means that dumping will not contain previous dumped messages.")
    private boolean removeOnDump = true;
    public static final String ENABLED = "enabled";
    public static final String DUMP = "dump";
    public static final String ENDPOINT = "endpoint";
    private final List<Consumer> consumers = new ArrayList<Consumer>();
    private final AtomicBoolean enabled = new AtomicBoolean();
    private final AtomicLong uuid = new AtomicLong();
    private Queue<JsonObject> queue;
    private long firstTimestamp;
    private long lastTimestamp;

    public ReceiveDevConsole() {
        super("camel", "receive", "Camel Receive", "Consume messages from endpoints");
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public int getBodyMaxChars() {
        return this.bodyMaxChars;
    }

    public void setBodyMaxChars(int bodyMaxChars) {
        this.bodyMaxChars = bodyMaxChars;
    }

    public boolean isRemoveOnDump() {
        return this.removeOnDump;
    }

    public void setRemoveOnDump(boolean removeOnDump) {
        this.removeOnDump = removeOnDump;
    }

    protected void doInit() throws Exception {
        if (this.capacity > 1000 || this.capacity < 50) {
            throw new IllegalArgumentException("Capacity must be between 50 and 1000");
        }
        this.queue = new LinkedBlockingQueue<JsonObject>(this.capacity);
    }

    protected void doStop() throws Exception {
        this.stopConsumers();
    }

    protected void stopConsumers() {
        for (Consumer c : this.consumers) {
            ServiceHelper.stopAndShutdownServices((Object[])new Object[]{c});
        }
        this.consumers.clear();
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        String dump = (String)options.get(DUMP);
        if ("true".equals(dump)) {
            JsonArray arr = new JsonArray();
            arr.addAll(this.queue);
            if (this.removeOnDump) {
                this.queue.clear();
            }
            JsonObject jo = (JsonObject)arr.get(0);
            this.firstTimestamp = jo.getLongOrDefault("timestamp", 0L);
            jo = (JsonObject)arr.get(arr.size() - 1);
            this.lastTimestamp = jo.getLongOrDefault("timestamp", 0L);
            String json = arr.toJson();
            sb.append(json).append("\n");
            return sb.toString();
        }
        String enabled = (String)options.get(ENABLED);
        if ("false".equals(enabled)) {
            this.stopConsumers();
            this.enabled.set(false);
            sb.append("Enabled: ").append("false").append("\n");
            return sb.toString();
        }
        String pattern = (String)options.get(ENDPOINT);
        if (pattern != null) {
            try {
                Endpoint target = ReceiveDevConsole.findMatchingEndpoint(this.getCamelContext(), pattern);
                if (target != null) {
                    sb.append("Starting to receive messages from: ").append(target.getEndpointUri());
                    Consumer consumer = this.createConsumer(target);
                    if (!this.consumers.contains(consumer)) {
                        this.consumers.add(consumer);
                        ServiceHelper.startService((Service)consumer);
                    }
                }
                this.enabled.set(true);
            }
            catch (Exception e) {
                sb.append("Error starting to receive messages due to: ").append(e.getMessage());
            }
        }
        sb.append("Enabled: ").append(this.enabled.get()).append("\n");
        sb.append("Total: ").append(this.uuid.get()).append("\n");
        for (Consumer c : this.consumers) {
            sb.append("    ").append(c.getEndpoint().toString()).append("\n");
        }
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        String dump = (String)options.get(DUMP);
        if ("true".equals(dump)) {
            JsonArray arr = new JsonArray();
            arr.addAll(this.queue);
            if (this.removeOnDump) {
                this.queue.clear();
            }
            root.put((Object)"messages", (Object)arr);
            JsonObject jo = (JsonObject)arr.get(0);
            this.firstTimestamp = jo.getLongOrDefault("timestamp", 0L);
            jo = (JsonObject)arr.get(arr.size() - 1);
            this.lastTimestamp = jo.getLongOrDefault("timestamp", 0L);
            return root;
        }
        String enabled = (String)options.get(ENABLED);
        if ("false".equals(enabled)) {
            this.stopConsumers();
            this.enabled.set(false);
            root.put((Object)ENABLED, (Object)false);
            return root;
        }
        String pattern = (String)options.get(ENDPOINT);
        if (pattern != null) {
            try {
                Endpoint target = ReceiveDevConsole.findMatchingEndpoint(this.getCamelContext(), pattern);
                if (target != null) {
                    root.put((Object)"url", (Object)target.getEndpointUri());
                    Consumer consumer = this.createConsumer(target);
                    if (!this.consumers.contains(consumer)) {
                        this.consumers.add(consumer);
                        ServiceHelper.startService((Service)consumer);
                    }
                }
                this.enabled.set(true);
            }
            catch (Exception e) {
                root.put((Object)"error", (Object)Jsoner.escape((String)e.getMessage()));
                JsonArray arr2 = new JsonArray();
                String trace = ExceptionHelper.stackTraceToString((Throwable)e);
                root.put((Object)"stackTrace", (Object)arr2);
                Collections.addAll(arr2, trace.split("\n"));
            }
        }
        root.put((Object)ENABLED, (Object)this.enabled.get());
        root.put((Object)"total", (Object)this.uuid.get());
        root.put((Object)"firstTimestamp", (Object)this.firstTimestamp);
        root.put((Object)"lastTimestamp", (Object)this.lastTimestamp);
        JsonArray arr = new JsonArray();
        for (Consumer c : this.consumers) {
            JsonObject jo = new JsonObject();
            jo.put((Object)"uri", (Object)c.getEndpoint().toString());
            jo.put((Object)"remote", (Object)c.getEndpoint().isRemote());
            arr.add((Object)jo);
        }
        if (!arr.isEmpty()) {
            root.put((Object)"endpoints", (Object)arr);
        }
        return root;
    }

    private Consumer createConsumer(Endpoint target) throws Exception {
        for (Consumer c : this.consumers) {
            if (c.getEndpoint() != target) continue;
            return c;
        }
        return target.createConsumer(this::addMessage);
    }

    private void addMessage(Exchange exchange) {
        JsonObject json = MessageHelper.dumpAsJSonObject((Message)exchange.getMessage(), (boolean)false, (boolean)false, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (int)this.bodyMaxChars);
        json.put((Object)"uid", (Object)this.uuid.incrementAndGet());
        json.put((Object)"endpointUri", (Object)exchange.getFromEndpoint().toString());
        json.put((Object)"remoteEndpoint", (Object)exchange.getFromEndpoint().isRemote());
        this.lastTimestamp = exchange.getMessage().getMessageTimestamp();
        json.put((Object)"timestamp", (Object)this.lastTimestamp);
        int drain = this.queue.size() - this.capacity + 1;
        if (drain > 0) {
            for (int i = 0; i < drain; ++i) {
                this.queue.poll();
            }
        }
        this.queue.add(json);
    }

    protected static Endpoint findMatchingEndpoint(CamelContext camelContext, String endpoint) {
        Endpoint target = null;
        boolean scheme = ((String)endpoint).contains(":");
        boolean pattern = ((String)endpoint).endsWith("*");
        if (!scheme || pattern) {
            MBeanServer mbeanServer;
            if (!scheme && !((String)endpoint).endsWith("*")) {
                endpoint = (String)endpoint + "*";
            }
            if ((mbeanServer = camelContext.getManagementStrategy().getManagementAgent().getMBeanServer()) != null) {
                try {
                    String jmxDomain = camelContext.getManagementStrategy().getManagementAgent().getMBeanObjectDomainName();
                    String prefix = camelContext.getManagementStrategy().getManagementAgent().getIncludeHostName() != false ? "*/" : "";
                    ObjectName query = ObjectName.getInstance(jmxDomain + ":context=" + prefix + camelContext.getManagementName() + ",type=producers,*");
                    Set<ObjectName> set = mbeanServer.queryNames(query, null);
                    if (set != null && !set.isEmpty()) {
                        for (ObjectName on : set) {
                            String uri = (String)mbeanServer.getAttribute(on, "EndpointUri");
                            if (!PatternHelper.matchPattern((String)uri, (String)endpoint)) continue;
                            target = camelContext.getEndpoint(uri);
                            UriEndpoint ann = (UriEndpoint)ObjectHelper.getAnnotationDeep((Object)target, UriEndpoint.class);
                            if (ann != null) {
                                if (ann.producerOnly()) {
                                    target = null;
                                }
                                if ("*".equals(endpoint) && !ann.remote()) {
                                    target = null;
                                }
                            }
                            if (target == null) continue;
                        }
                    }
                }
                catch (Exception exception) {}
            }
        } else {
            target = camelContext.getEndpoint((String)endpoint);
            UriEndpoint ann = (UriEndpoint)ObjectHelper.getAnnotationDeep((Object)target, UriEndpoint.class);
            if (ann != null && ann.producerOnly()) {
                throw new IllegalArgumentException("Cannot consume from endpoint: " + (String)endpoint);
            }
        }
        return target;
    }
}

