/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.console.DevConsoleRegistry;
import org.apache.camel.console.DevConsoleResolver;
import org.apache.camel.impl.console.DefaultDevConsolesLoader;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DevConsole(name="default-registry", description="Default Console Registry")
@DeferredContextBinding
public class DefaultDevConsoleRegistry
extends ServiceSupport
implements DevConsoleRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDevConsoleRegistry.class);
    private String id = "camel-console";
    private CamelContext camelContext;
    private final Set<org.apache.camel.console.DevConsole> consoles = new TreeSet<org.apache.camel.console.DevConsole>(Comparator.comparing(org.apache.camel.console.DevConsole::getId));
    private boolean enabled = true;
    private volatile boolean loadDevConsolesDone;

    public DefaultDevConsoleRegistry() {
        this(null);
    }

    public DefaultDevConsoleRegistry(CamelContext camelContext) {
        this.setCamelContext(camelContext);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    protected void doInit() throws Exception {
        for (org.apache.camel.console.DevConsole console : this.consoles) {
            CamelContextAware.trySetCamelContext((Object)console, (CamelContext)this.camelContext);
            ServiceHelper.initService((Object)console);
        }
    }

    protected void doStart() throws Exception {
        for (org.apache.camel.console.DevConsole console : this.consoles) {
            ServiceHelper.startService((Object)console);
        }
    }

    protected void doStop() throws Exception {
        for (org.apache.camel.console.DevConsole console : this.consoles) {
            ServiceHelper.stopService((Object)console);
        }
    }

    public org.apache.camel.console.DevConsole resolveById(String id) {
        DevConsoleResolver resolver;
        org.apache.camel.console.DevConsole answer = this.consoles.stream().filter(h -> h.getId().equals(id)).findFirst().orElse((org.apache.camel.console.DevConsole)this.camelContext.getRegistry().findByTypeWithName(org.apache.camel.console.DevConsole.class).get(id));
        if (answer == null && (answer = (resolver = PluginHelper.getDevConsoleResolver((CamelContext)this.camelContext)).resolveDevConsole(id)) != null) {
            this.register(answer);
        }
        return answer;
    }

    public boolean register(org.apache.camel.console.DevConsole console) {
        if (this.getConsole(console.getId()).isPresent()) {
            return false;
        }
        boolean result = this.consoles.add(console);
        if (result) {
            CamelContextAware.trySetCamelContext((Object)console, (CamelContext)this.camelContext);
            ServiceHelper.startService((Object)console);
            LOG.debug("DevConsole with id {} successfully registered", (Object)console.getId());
        }
        return result;
    }

    public boolean unregister(org.apache.camel.console.DevConsole console) {
        boolean result = this.consoles.remove(console);
        if (result) {
            LOG.debug("DevConsole with id {} successfully un-registered", (Object)console.getId());
        }
        return result;
    }

    public Stream<org.apache.camel.console.DevConsole> stream() {
        if (this.enabled) {
            return this.consoles.stream();
        }
        return Stream.empty();
    }

    public void loadDevConsoles() {
        this.loadDevConsoles(false);
    }

    public void loadDevConsoles(boolean force) {
        StopWatch watch = new StopWatch();
        if (!this.loadDevConsolesDone || force) {
            this.loadDevConsolesDone = true;
            DefaultDevConsolesLoader loader = new DefaultDevConsolesLoader(this.camelContext);
            Collection<org.apache.camel.console.DevConsole> col = loader.loadDevConsoles(force);
            if (!col.isEmpty()) {
                int added = 0;
                for (org.apache.camel.console.DevConsole console : col) {
                    if (!this.register(console)) continue;
                    ++added;
                }
                String time = TimeUtils.printDuration((long)watch.taken(), (boolean)true);
                LOG.debug("Dev consoles (scanned: {} registered: {}) loaded in {}", new Object[]{col.size(), added, time});
            }
        }
    }
}

