/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.spi.BrowsableEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="browse", description="Browse pending messages on Camel components")
public class BrowseDevConsole
extends AbstractDevConsole {
    public static final String FILTER = "filter";
    public static final String LIMIT = "limit";
    public static final String DUMP = "dump";
    @Metadata(defaultValue="32768", description="Maximum size of the message body to include in the dump")
    private int bodyMaxChars = 32768;
    @Metadata(defaultValue="100", description="Maximum number of messages per endpoint to include in the dump")
    private int limit = 100;

    public BrowseDevConsole() {
        super("camel", "browse", "Browse", "Browse pending messages on Camel components");
    }

    public int getBodyMaxChars() {
        return this.bodyMaxChars;
    }

    public void setBodyMaxChars(int bodyMaxChars) {
        this.bodyMaxChars = bodyMaxChars;
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        String filter = (String)options.get(FILTER);
        String lim = (String)options.get(LIMIT);
        int max = lim == null ? this.limit : Integer.parseInt(lim);
        boolean dump = "true".equals(options.getOrDefault(DUMP, "true"));
        TreeSet<Endpoint> endpoints = new TreeSet<Endpoint>(Comparator.comparing(Endpoint::getEndpointUri));
        endpoints.addAll(this.getCamelContext().getEndpoints());
        for (Endpoint endpoint : endpoints) {
            long size;
            if (!(endpoint instanceof BrowsableEndpoint)) continue;
            BrowsableEndpoint be = (BrowsableEndpoint)endpoint;
            if (filter != null && !PatternHelper.matchPattern((String)endpoint.getEndpointUri(), (String)filter)) continue;
            List list = be.getExchanges();
            long l = size = list != null ? (long)list.size() : 0L;
            if (list != null && list.size() > max) {
                size = list.size();
                list = list.subList(0, max);
            }
            if (list == null) continue;
            sb.append("\n");
            sb.append(String.format("Browse: %s (size: %d)%n", endpoint.getEndpointUri(), size));
            if (!dump) continue;
            for (Exchange e : list) {
                String json = MessageHelper.dumpAsJSon((Message)e.getMessage(), (boolean)false, (boolean)false, (boolean)true, (int)2, (boolean)true, (boolean)true, (boolean)true, (int)this.bodyMaxChars, (boolean)true);
                sb.append(json);
                sb.append("\n");
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        JsonArray arr = new JsonArray();
        String filter = (String)options.get(FILTER);
        String lim = (String)options.get(LIMIT);
        int max = lim == null ? this.limit : Integer.parseInt(lim);
        boolean dump = "true".equals(options.getOrDefault(DUMP, "true"));
        TreeSet<Endpoint> endpoints = new TreeSet<Endpoint>(Comparator.comparing(Endpoint::getEndpointUri));
        endpoints.addAll(this.getCamelContext().getEndpoints());
        for (Endpoint endpoint : endpoints) {
            long size;
            if (!(endpoint instanceof BrowsableEndpoint)) continue;
            BrowsableEndpoint be = (BrowsableEndpoint)endpoint;
            if (filter != null && !PatternHelper.matchPattern((String)endpoint.getEndpointUri(), (String)filter)) continue;
            List list = be.getExchanges();
            long l = size = list != null ? (long)list.size() : 0L;
            if (list != null && list.size() > max) {
                size = list.size();
                list = list.subList(0, max);
            }
            if (list == null) continue;
            JsonObject jo = new JsonObject();
            jo.put((Object)"endpointUri", (Object)endpoint.getEndpointUri());
            jo.put((Object)"size", (Object)size);
            arr.add((Object)jo);
            if (!dump) continue;
            JsonArray arr2 = new JsonArray();
            for (Exchange e : list) {
                arr2.add((Object)MessageHelper.dumpAsJSonObject((Message)e.getMessage(), (boolean)false, (boolean)false, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (int)this.bodyMaxChars));
            }
            if (arr2.isEmpty()) continue;
            jo.put((Object)"messages", (Object)arr2);
        }
        if (!arr.isEmpty()) {
            root.put((Object)"browse", (Object)arr);
        }
        return root;
    }
}

