/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.io.Closeable;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.api.management.ManagedCamelContext;
import org.apache.camel.api.management.mbean.ManagedRouteMBean;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.LoggerHelper;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;

@DevConsole(name="route-dump", description="Dump route in XML or YAML format")
public class RouteDumpDevConsole
extends AbstractDevConsole {
    private static final Pattern XML_SOURCE_LOCATION_PATTERN = Pattern.compile("(\\ssourceLocation=\"(.*?)\")");
    private static final Pattern XML_SOURCE_LINE_PATTERN = Pattern.compile("(\\ssourceLineNumber=\"(.*?)\")");
    public static final String FORMAT = "format";
    public static final String FILTER = "filter";
    public static final String LIMIT = "limit";
    public static final String URI_AS_PARAMETERS = "uriAsParameters";

    public RouteDumpDevConsole() {
        super("camel", "route-dump", "Route Dump", "Dump route in XML or YAML format");
    }

    protected String doCallText(Map<String, Object> options) {
        String uriAsParameters = (String)options.getOrDefault(URI_AS_PARAMETERS, "false");
        StringBuilder sb = new StringBuilder();
        Function<ManagedRouteMBean, Object> task = mrb -> {
            String dump = null;
            try {
                String format = (String)options.get(FORMAT);
                if (format == null || "xml".equals(format)) {
                    dump = mrb.dumpRouteAsXml(true);
                } else if ("yaml".equals(format)) {
                    dump = mrb.dumpRouteAsYaml(true, "true".equals(uriAsParameters));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            sb.append(String.format("    Id: %s", mrb.getRouteId()));
            if (mrb.getSourceLocation() != null) {
                sb.append(String.format("\n    Source: %s", mrb.getSourceLocation()));
            }
            if (dump != null && !dump.isEmpty()) {
                sb.append("\n\n");
                for (String line : dump.split("\n")) {
                    sb.append("    ").append(line).append("\n");
                }
                sb.append("\n");
            }
            sb.append("\n");
            return null;
        };
        this.doCall(options, task);
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        String uriAsParameters = (String)options.getOrDefault(URI_AS_PARAMETERS, "false");
        JsonObject root = new JsonObject();
        ArrayList list = new ArrayList();
        Function<ManagedRouteMBean, Object> task = mrb -> {
            JsonObject jo = new JsonObject();
            list.add(jo);
            jo.put((Object)"routeId", (Object)mrb.getRouteId());
            jo.put((Object)"from", (Object)mrb.getEndpointUri());
            if (mrb.getSourceLocation() != null) {
                jo.put((Object)"source", (Object)mrb.getSourceLocation());
            }
            try {
                List<JsonObject> code;
                String dump = null;
                String format = (String)options.get(FORMAT);
                if (format == null || "xml".equals(format)) {
                    jo.put((Object)FORMAT, (Object)"xml");
                    dump = mrb.dumpRouteAsXml(true, false, true);
                } else if ("yaml".equals(format)) {
                    jo.put((Object)FORMAT, (Object)"yaml");
                    dump = mrb.dumpRouteAsYaml(true, "true".equals(uriAsParameters), false, true);
                }
                if (dump != null && (code = format == null || "xml".equals(format) ? RouteDumpDevConsole.xmlLoadSourceAsJson(new StringReader(dump)) : RouteDumpDevConsole.yamlLoadSourceAsJson(new StringReader(dump))) != null) {
                    jo.put((Object)"code", code);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        };
        this.doCall(options, task);
        root.put((Object)"routes", list);
        return root;
    }

    protected void doCall(Map<String, Object> options, Function<ManagedRouteMBean, Object> task) {
        String path = (String)options.get("CamelHttpPath");
        String subPath = path != null ? StringHelper.after((String)path, (String)"/") : null;
        String filter = (String)options.get(FILTER);
        String limit = (String)options.get(LIMIT);
        int max = limit == null ? Integer.MAX_VALUE : Integer.parseInt(limit);
        ManagedCamelContext mcc = (ManagedCamelContext)this.getCamelContext().getCamelContextExtension().getContextPlugin(ManagedCamelContext.class);
        if (mcc != null) {
            List routes = this.getCamelContext().getRoutes();
            routes.sort((o1, o2) -> o1.getRouteId().compareToIgnoreCase(o2.getRouteId()));
            routes.stream().map(route -> mcc.getManagedRoute(route.getRouteId())).filter(Objects::nonNull).filter(r -> RouteDumpDevConsole.accept(r, filter)).filter(r -> RouteDumpDevConsole.accept(r, subPath)).sorted(RouteDumpDevConsole::sort).limit(max).forEach(task::apply);
        }
    }

    private static boolean accept(ManagedRouteMBean mrb, String filter) {
        if (filter == null || filter.isBlank()) {
            return true;
        }
        String onlyName = LoggerHelper.sourceNameOnly((String)mrb.getSourceLocation());
        return PatternHelper.matchPattern((String)mrb.getRouteId(), (String)filter) || PatternHelper.matchPattern((String)mrb.getEndpointUri(), (String)filter) || PatternHelper.matchPattern((String)mrb.getSourceLocationShort(), (String)filter) || PatternHelper.matchPattern((String)onlyName, (String)filter);
    }

    private static int sort(ManagedRouteMBean o1, ManagedRouteMBean o2) {
        return o1.getRouteId().compareTo(o2.getRouteId());
    }

    private static List<JsonObject> xmlLoadSourceAsJson(Reader reader) {
        ArrayList<JsonObject> code = new ArrayList<JsonObject>();
        try {
            String t;
            LineNumberReader lnr = new LineNumberReader(reader);
            do {
                if ((t = lnr.readLine()) == null) continue;
                String idx = null;
                Matcher m = XML_SOURCE_LOCATION_PATTERN.matcher(t);
                if (m.find()) {
                    t = m.replaceFirst("");
                }
                if ((m = XML_SOURCE_LINE_PATTERN.matcher(t)).find()) {
                    idx = m.group(2);
                    t = m.replaceFirst("");
                }
                JsonObject c = new JsonObject();
                c.put((Object)"line", (Object)(idx != null ? Integer.parseInt(idx) : -1));
                c.put((Object)"code", (Object)Jsoner.escape((String)t));
                code.add(c);
            } while (t != null);
            IOHelper.close((Closeable)lnr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return code.isEmpty() ? null : code;
    }

    private static List<JsonObject> yamlLoadSourceAsJson(Reader reader) {
        ArrayList<JsonObject> code = new ArrayList<JsonObject>();
        try {
            String t;
            LineNumberReader lnr = new LineNumberReader(reader);
            do {
                if ((t = lnr.readLine()) == null || t.contains("sourceLocation: ")) continue;
                if (t.contains("sourceLineNumber: ")) {
                    String idx = StringHelper.after((String)t, (String)"sourceLineNumber: ").trim();
                    if (code.isEmpty()) continue;
                    JsonObject c = (JsonObject)code.get(code.size() - 1);
                    try {
                        c.put((Object)"line", (Object)Integer.parseInt(idx));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                JsonObject c = new JsonObject();
                c.put((Object)"code", (Object)Jsoner.escape((String)t));
                c.put((Object)"line", (Object)-1);
                code.add(c);
            } while (t != null);
            IOHelper.close((Closeable)lnr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return code.isEmpty() ? null : code;
    }
}

