/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.api.management.ManagedCamelContext;
import org.apache.camel.api.management.mbean.ManagedProcessorMBean;
import org.apache.camel.api.management.mbean.ManagedRouteMBean;
import org.apache.camel.impl.console.ConsoleHelper;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.ExceptionHelper;
import org.apache.camel.support.LoggerHelper;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DevConsole(name="route", description="Route information")
public class RouteDevConsole
extends AbstractDevConsole {
    private static final Logger LOG = LoggerFactory.getLogger(RouteDevConsole.class);
    public static final String FILTER = "filter";
    public static final String LIMIT = "limit";
    public static final String PROCESSORS = "processors";
    public static final String ACTION = "action";

    public RouteDevConsole() {
        super("camel", "route", "Route", "Route information");
    }

    protected String doCallText(Map<String, Object> options) {
        String action = (String)options.get(ACTION);
        String filter = (String)options.get(FILTER);
        if (action != null) {
            this.doAction(this.getCamelContext(), action, filter);
            return "";
        }
        boolean processors = "true".equals(options.getOrDefault(PROCESSORS, "false"));
        StringBuilder sb = new StringBuilder();
        Function<ManagedRouteMBean, Object> task = mrb -> {
            String ago;
            Date last;
            String thp;
            if (!sb.isEmpty()) {
                sb.append("\n");
            }
            sb.append(String.format("    Id: %s", mrb.getRouteId()));
            if (mrb.getNodePrefixId() != null) {
                sb.append(String.format("\n    Node Prefix Id: %s", mrb.getNodePrefixId()));
            }
            if (mrb.getRouteGroup() != null) {
                sb.append(String.format("\n    Group: %s", mrb.getRouteGroup()));
            }
            if (mrb.getDescription() != null) {
                sb.append(String.format("\n    Description: %s", mrb.getDescription()));
            }
            sb.append(String.format("\n    From: %s", mrb.getEndpointUri()));
            sb.append(String.format("\n    Remote: %s", mrb.isRemoteEndpoint()));
            if (mrb.getSourceLocation() != null) {
                sb.append(String.format("\n    Source: %s", mrb.getSourceLocation()));
            }
            sb.append(String.format("\n    State: %s", mrb.getState()));
            if (mrb.getLastError() != null) {
                String phase = StringHelper.capitalize((String)mrb.getLastError().getPhase().name().toLowerCase());
                String ago2 = TimeUtils.printSince((long)mrb.getLastError().getDate().getTime());
                sb.append(String.format("\n    Error Ago: %s", ago2));
                sb.append(String.format("\n    Error Phase: %s", phase));
                Throwable cause = mrb.getLastError().getException();
                if (cause != null) {
                    sb.append(String.format("\n    Error Message: %s", cause.getMessage()));
                    String stackTrace = ExceptionHelper.stackTraceToString((Throwable)cause);
                    sb.append("\n\n");
                    sb.append(stackTrace);
                    sb.append("\n\n");
                }
            }
            sb.append(String.format("\n    Uptime: %s", mrb.getUptime()));
            String coverage = this.calculateRouteCoverage((ManagedRouteMBean)mrb, true);
            if (coverage != null) {
                sb.append(String.format("\n    Coverage: %s", coverage));
            }
            String load1 = this.getLoad1((ManagedRouteMBean)mrb);
            String load5 = this.getLoad5((ManagedRouteMBean)mrb);
            String load15 = this.getLoad15((ManagedRouteMBean)mrb);
            if (!(load1.isEmpty() && load5.isEmpty() && load15.isEmpty())) {
                sb.append(String.format("\n    Load Average: %s %s %s", load1, load5, load15));
            }
            if (!(thp = this.getThroughput((ManagedRouteMBean)mrb)).isEmpty()) {
                sb.append(String.format("\n    Messages/Sec: %s", thp));
            }
            sb.append(String.format("\n    Total: %s", mrb.getExchangesTotal()));
            sb.append(String.format("\n    Failed: %s", mrb.getExchangesFailed()));
            sb.append(String.format("\n    Inflight: %s", mrb.getExchangesInflight()));
            long idle = mrb.getIdleSince();
            if (idle > 0L) {
                sb.append(String.format("\n    Idle Since: %s", TimeUtils.printDuration((long)idle)));
            } else {
                sb.append(String.format("\n    Idle Since: %s", ""));
            }
            sb.append(String.format("\n    Mean Time: %s", TimeUtils.printDuration((long)mrb.getMeanProcessingTime(), (boolean)true)));
            sb.append(String.format("\n    Max Time: %s", TimeUtils.printDuration((long)mrb.getMaxProcessingTime(), (boolean)true)));
            sb.append(String.format("\n    Min Time: %s", TimeUtils.printDuration((long)mrb.getMinProcessingTime(), (boolean)true)));
            if (mrb.getExchangesTotal() > 0L) {
                sb.append(String.format("\n    Last Time: %s", TimeUtils.printDuration((long)mrb.getLastProcessingTime(), (boolean)true)));
                sb.append(String.format("\n    Delta Time: %s", TimeUtils.printDuration((long)mrb.getDeltaProcessingTime(), (boolean)true)));
            }
            if ((last = mrb.getLastExchangeCreatedTimestamp()) != null) {
                ago = TimeUtils.printSince((long)last.getTime());
                sb.append(String.format("\n    Since Last Started: %s", ago));
            }
            if ((last = mrb.getLastExchangeCompletedTimestamp()) != null) {
                ago = TimeUtils.printSince((long)last.getTime());
                sb.append(String.format("\n    Since Last Completed: %s", ago));
            }
            if ((last = mrb.getLastExchangeFailureTimestamp()) != null) {
                ago = TimeUtils.printSince((long)last.getTime());
                sb.append(String.format("\n    Since Last Failed: %s", ago));
            }
            if (processors) {
                this.includeProcessorsText((ManagedRouteMBean)mrb, sb);
            }
            sb.append("\n");
            return null;
        };
        this.doCall(options, task);
        return sb.toString();
    }

    private void includeProcessorsText(ManagedRouteMBean mrb, StringBuilder sb) {
        Collection ids;
        ManagedCamelContext mcc = (ManagedCamelContext)this.getCamelContext().getCamelContextExtension().getContextPlugin(ManagedCamelContext.class);
        try {
            ids = mrb.processorIds();
        }
        catch (Exception e) {
            return;
        }
        ArrayList<ManagedProcessorMBean> mps = new ArrayList<ManagedProcessorMBean>();
        for (String id : ids) {
            ManagedProcessorMBean mp = mcc.getManagedProcessor(id);
            if (mp == null) continue;
            mps.add(mp);
        }
        mps.sort(Comparator.comparingInt(ManagedProcessorMBean::getIndex));
        for (ManagedProcessorMBean mp : mps) {
            String ago;
            Date last;
            sb.append("\n");
            sb.append(String.format("\n        Id: %s", mp.getProcessorId()));
            if (mp.getNodePrefixId() != null) {
                sb.append(String.format("\n        Node Prefix Id: %s", mp.getNodePrefixId()));
            }
            if (mp.getDescription() != null) {
                sb.append(String.format("\n        Description: %s", mp.getDescription()));
            }
            sb.append(String.format("\n        Processor: %s", mp.getProcessorName()));
            sb.append(String.format("\n        Level: %d", mp.getLevel()));
            if (mp.getSourceLocation() != null) {
                Object loc = mp.getSourceLocation();
                if (mp.getSourceLineNumber() != null) {
                    loc = (String)loc + ":" + mp.getSourceLineNumber();
                }
                sb.append(String.format("\n        Source: %s", loc));
            }
            sb.append(String.format("\n        State: %s", mp.getState()));
            sb.append(String.format("\n        Disabled: %s", mp.getDisabled()));
            sb.append(String.format("\n        Total: %s", mp.getExchangesTotal()));
            sb.append(String.format("\n        Failed: %s", mp.getExchangesFailed()));
            sb.append(String.format("\n        Inflight: %s", mp.getExchangesInflight()));
            long idle = mp.getIdleSince();
            if (idle > 0L) {
                sb.append(String.format("\n        Idle Since: %s", TimeUtils.printDuration((long)idle)));
            } else {
                sb.append(String.format("\n        Idle Since: %s", ""));
            }
            sb.append(String.format("\n        Mean Time: %s", TimeUtils.printDuration((long)mp.getMeanProcessingTime(), (boolean)true)));
            sb.append(String.format("\n        Max Time: %s", TimeUtils.printDuration((long)mp.getMaxProcessingTime(), (boolean)true)));
            sb.append(String.format("\n        Min Time: %s", TimeUtils.printDuration((long)mp.getMinProcessingTime(), (boolean)true)));
            if (mp.getExchangesTotal() > 0L) {
                sb.append(String.format("\n        Last Time: %s", TimeUtils.printDuration((long)mp.getLastProcessingTime(), (boolean)true)));
                sb.append(String.format("\n        Delta Time: %s", TimeUtils.printDuration((long)mp.getDeltaProcessingTime(), (boolean)true)));
            }
            if ((last = mp.getLastExchangeCompletedTimestamp()) != null) {
                ago = TimeUtils.printSince((long)last.getTime());
                sb.append(String.format("\n        Since Last Completed: %s", ago));
            }
            if ((last = mp.getLastExchangeFailureTimestamp()) == null) continue;
            ago = TimeUtils.printSince((long)last.getTime());
            sb.append(String.format("\n        Since Last Failed: %s", ago));
        }
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        String action = (String)options.get(ACTION);
        String filter = (String)options.get(FILTER);
        if (action != null) {
            this.doAction(this.getCamelContext(), action, filter);
            return new JsonObject();
        }
        boolean processors = "true".equals(options.getOrDefault(PROCESSORS, "false"));
        JsonObject root = new JsonObject();
        ArrayList list = new ArrayList();
        Function<ManagedRouteMBean, Object> task = mrb -> {
            Date last;
            String thp;
            JsonObject jo = new JsonObject();
            list.add(jo);
            jo.put((Object)"routeId", (Object)mrb.getRouteId());
            if (mrb.getRouteGroup() != null) {
                jo.put((Object)"group", (Object)mrb.getRouteGroup());
            }
            if (mrb.getNodePrefixId() != null) {
                jo.put((Object)"nodePrefixId", (Object)mrb.getNodePrefixId());
            }
            if (mrb.getDescription() != null) {
                jo.put((Object)"description", (Object)mrb.getDescription());
            }
            jo.put((Object)"from", (Object)mrb.getEndpointUri());
            jo.put((Object)"remote", (Object)mrb.isRemoteEndpoint());
            if (mrb.getSourceLocation() != null) {
                jo.put((Object)"source", (Object)mrb.getSourceLocation());
            }
            jo.put((Object)"state", (Object)mrb.getState());
            jo.put((Object)"uptime", (Object)mrb.getUptime());
            if (mrb.getLastError() != null) {
                String phase = StringHelper.capitalize((String)mrb.getLastError().getPhase().name().toLowerCase());
                JsonObject eo = new JsonObject();
                eo.put((Object)"phase", (Object)phase);
                eo.put((Object)"timestamp", (Object)mrb.getLastError().getDate().getTime());
                Throwable cause = mrb.getLastError().getException();
                if (cause != null) {
                    eo.put((Object)"message", (Object)cause.getMessage());
                    JsonArray arr2 = new JsonArray();
                    String trace = ExceptionHelper.stackTraceToString((Throwable)cause);
                    eo.put((Object)"stackTrace", (Object)arr2);
                    Collections.addAll(arr2, trace.split("\n"));
                }
                jo.put((Object)"lastError", (Object)eo);
            }
            JsonObject stats = new JsonObject();
            String coverage = this.calculateRouteCoverage((ManagedRouteMBean)mrb, false);
            if (coverage != null) {
                stats.put((Object)"coverage", (Object)coverage);
            }
            String load1 = this.getLoad1((ManagedRouteMBean)mrb);
            String load5 = this.getLoad5((ManagedRouteMBean)mrb);
            String load15 = this.getLoad15((ManagedRouteMBean)mrb);
            if (!(load1.isEmpty() && load5.isEmpty() && load15.isEmpty())) {
                stats.put((Object)"load01", (Object)load1);
                stats.put((Object)"load05", (Object)load5);
                stats.put((Object)"load15", (Object)load15);
            }
            if (!(thp = this.getThroughput((ManagedRouteMBean)mrb)).isEmpty()) {
                stats.put((Object)"exchangesThroughput", (Object)thp);
            }
            stats.put((Object)"idleSince", (Object)mrb.getIdleSince());
            stats.put((Object)"exchangesTotal", (Object)mrb.getExchangesTotal());
            stats.put((Object)"exchangesFailed", (Object)mrb.getExchangesFailed());
            stats.put((Object)"exchangesInflight", (Object)mrb.getExchangesInflight());
            stats.put((Object)"meanProcessingTime", (Object)mrb.getMeanProcessingTime());
            stats.put((Object)"maxProcessingTime", (Object)mrb.getMaxProcessingTime());
            stats.put((Object)"minProcessingTime", (Object)mrb.getMinProcessingTime());
            if (mrb.getExchangesTotal() > 0L) {
                stats.put((Object)"lastProcessingTime", (Object)mrb.getLastProcessingTime());
                stats.put((Object)"deltaProcessingTime", (Object)mrb.getDeltaProcessingTime());
            }
            if ((last = mrb.getLastExchangeCreatedTimestamp()) != null) {
                stats.put((Object)"lastCreatedExchangeTimestamp", (Object)last.getTime());
            }
            if ((last = mrb.getLastExchangeCompletedTimestamp()) != null) {
                stats.put((Object)"lastCompletedExchangeTimestamp", (Object)last.getTime());
            }
            if ((last = mrb.getLastExchangeFailureTimestamp()) != null) {
                stats.put((Object)"lastFailedExchangeTimestamp", (Object)last.getTime());
            }
            jo.put((Object)"statistics", (Object)stats);
            if (processors) {
                JsonArray arr = new JsonArray();
                jo.put((Object)PROCESSORS, (Object)arr);
                this.includeProcessorsJson((ManagedRouteMBean)mrb, arr);
            }
            return null;
        };
        this.doCall(options, task);
        root.put((Object)"routes", list);
        return root;
    }

    private void includeProcessorsJson(ManagedRouteMBean mrb, JsonArray arr) {
        Collection ids;
        ManagedCamelContext mcc = (ManagedCamelContext)this.getCamelContext().getCamelContextExtension().getContextPlugin(ManagedCamelContext.class);
        try {
            ids = mrb.processorIds();
        }
        catch (Exception e) {
            return;
        }
        List<ManagedProcessorMBean> mps = ids.stream().map(arg_0 -> ((ManagedCamelContext)mcc).getManagedProcessor(arg_0)).filter(Objects::nonNull).sorted(Comparator.comparingInt(ManagedProcessorMBean::getIndex)).toList();
        for (ManagedProcessorMBean mp : mps) {
            JsonObject jo = new JsonObject();
            arr.add((Object)jo);
            jo.put((Object)"id", (Object)mp.getProcessorId());
            if (mp.getNodePrefixId() != null) {
                jo.put((Object)"nodePrefixId", (Object)mp.getNodePrefixId());
            }
            if (mp.getDescription() != null) {
                jo.put((Object)"description", (Object)mp.getDescription());
            }
            if (mp.getSourceLocation() != null) {
                Object loc = mp.getSourceLocation();
                if (mp.getSourceLineNumber() != null) {
                    loc = (String)loc + ":" + mp.getSourceLineNumber();
                }
                jo.put((Object)"source", loc);
            }
            jo.put((Object)"state", (Object)mp.getState());
            jo.put((Object)"disabled", (Object)mp.getDisabled());
            String line = ConsoleHelper.loadSourceLine(this.getCamelContext(), mp.getSourceLocation(), mp.getSourceLineNumber());
            if (line != null) {
                JsonArray ca = new JsonArray();
                jo.put((Object)"code", (Object)ca);
                JsonObject c = new JsonObject();
                if (mp.getSourceLineNumber() != null) {
                    c.put((Object)"line", (Object)mp.getSourceLineNumber());
                }
                c.put((Object)"code", (Object)Jsoner.escape((String)line));
                c.put((Object)"match", (Object)true);
                ca.add((Object)c);
            }
            jo.put((Object)"processor", (Object)mp.getProcessorName());
            jo.put((Object)"level", (Object)mp.getLevel());
            JsonObject stats = RouteDevConsole.getStatsObject(mp);
            jo.put((Object)"statistics", (Object)stats);
        }
    }

    private static JsonObject getStatsObject(ManagedProcessorMBean mp) {
        Date last;
        JsonObject stats = new JsonObject();
        stats.put((Object)"idleSince", (Object)mp.getIdleSince());
        stats.put((Object)"exchangesTotal", (Object)mp.getExchangesTotal());
        stats.put((Object)"exchangesFailed", (Object)mp.getExchangesFailed());
        stats.put((Object)"exchangesInflight", (Object)mp.getExchangesInflight());
        stats.put((Object)"meanProcessingTime", (Object)mp.getMeanProcessingTime());
        stats.put((Object)"maxProcessingTime", (Object)mp.getMaxProcessingTime());
        stats.put((Object)"minProcessingTime", (Object)mp.getMinProcessingTime());
        if (mp.getExchangesTotal() > 0L) {
            stats.put((Object)"lastProcessingTime", (Object)mp.getLastProcessingTime());
            stats.put((Object)"deltaProcessingTime", (Object)mp.getDeltaProcessingTime());
        }
        if ((last = mp.getLastExchangeCreatedTimestamp()) != null) {
            stats.put((Object)"lastCreatedExchangeTimestamp", (Object)last.getTime());
        }
        if ((last = mp.getLastExchangeCompletedTimestamp()) != null) {
            stats.put((Object)"lastCompletedExchangeTimestamp", (Object)last.getTime());
        }
        if ((last = mp.getLastExchangeFailureTimestamp()) != null) {
            stats.put((Object)"lastFailedExchangeTimestamp", (Object)last.getTime());
        }
        return stats;
    }

    protected void doCall(Map<String, Object> options, Function<ManagedRouteMBean, Object> task) {
        String path = (String)options.get("CamelHttpPath");
        String subPath = path != null ? StringHelper.after((String)path, (String)"/") : null;
        String filter = (String)options.get(FILTER);
        String limit = (String)options.get(LIMIT);
        int max = limit == null ? Integer.MAX_VALUE : Integer.parseInt(limit);
        ManagedCamelContext mcc = (ManagedCamelContext)this.getCamelContext().getCamelContextExtension().getContextPlugin(ManagedCamelContext.class);
        if (mcc != null) {
            List routes = this.getCamelContext().getRoutes();
            routes.sort((o1, o2) -> o1.getRouteId().compareToIgnoreCase(o2.getRouteId()));
            routes.stream().map(route -> mcc.getManagedRoute(route.getRouteId())).filter(Objects::nonNull).filter(r -> RouteDevConsole.accept(r, filter)).filter(r -> RouteDevConsole.accept(r, subPath)).sorted(RouteDevConsole::sort).limit(max).forEach(task::apply);
        }
    }

    private static boolean accept(ManagedRouteMBean mrb, String filter) {
        if (filter == null || filter.isBlank()) {
            return true;
        }
        if (filter.startsWith("group:")) {
            filter = filter.substring(6);
            return PatternHelper.matchPattern((String)mrb.getRouteGroup(), (String)filter);
        }
        String onlyName = LoggerHelper.sourceNameOnly((String)mrb.getSourceLocation());
        return PatternHelper.matchPattern((String)mrb.getRouteId(), (String)filter) || PatternHelper.matchPattern((String)mrb.getEndpointUri(), (String)filter) || PatternHelper.matchPattern((String)mrb.getSourceLocationShort(), (String)filter) || PatternHelper.matchPattern((String)onlyName, (String)filter);
    }

    private static int sort(ManagedRouteMBean o1, ManagedRouteMBean o2) {
        return o1.getRouteId().compareToIgnoreCase(o2.getRouteId());
    }

    private String getLoad1(ManagedRouteMBean mrb) {
        String s = mrb.getLoad01();
        s = s.replace(',', '.');
        return s;
    }

    private String getLoad5(ManagedRouteMBean mrb) {
        String s = mrb.getLoad05();
        s = s.replace(',', '.');
        return s;
    }

    private String getLoad15(ManagedRouteMBean mrb) {
        String s = mrb.getLoad15();
        s = s.replace(',', '.');
        return s;
    }

    private String getThroughput(ManagedRouteMBean mrb) {
        String s = mrb.getThroughput();
        s = s.replace(',', '.');
        return s;
    }

    private String calculateRouteCoverage(ManagedRouteMBean mrb, boolean percent) {
        Collection ids;
        ManagedCamelContext mcc = (ManagedCamelContext)this.getCamelContext().getCamelContextExtension().getContextPlugin(ManagedCamelContext.class);
        try {
            ids = mrb.processorIds();
        }
        catch (Exception e) {
            return null;
        }
        int total = ids.size();
        int covered = 0;
        for (String id : ids) {
            ManagedProcessorMBean mp = mcc.getManagedProcessor(id);
            if (mp == null || mp.getExchangesTotal() <= 0L) continue;
            ++covered;
        }
        if (percent) {
            double p = total > 0 ? (double)covered / (double)total * 100.0 : 0.0;
            String f = String.format("%.0f", p);
            return covered + "/" + total + " (" + f + "%)";
        }
        return covered + "/" + total;
    }

    protected void doAction(CamelContext camelContext, String command, String filter) {
        if (filter == null) {
            filter = "*";
        }
        String[] patterns = filter.split(",");
        List<String> ids = camelContext.getRoutes().stream().filter(r -> {
            for (String p : patterns) {
                String source = r.getRouteId();
                if (p.startsWith("group:")) {
                    source = r.getGroup();
                    p = p.substring(6);
                }
                if (!PatternHelper.matchPattern((String)source, (String)p)) continue;
                return true;
            }
            return false;
        }).map(Route::getRouteId).toList();
        for (String id : ids) {
            try {
                if ("start".equals(command)) {
                    if ("*".equals(id)) {
                        camelContext.getRouteController().startAllRoutes();
                        continue;
                    }
                    camelContext.getRouteController().startRoute(id);
                    continue;
                }
                if ("stop".equals(command)) {
                    if ("*".equals(id)) {
                        camelContext.getRouteController().stopAllRoutes();
                        continue;
                    }
                    camelContext.getRouteController().stopRoute(id);
                    continue;
                }
                if ("suspend".equals(command)) {
                    if ("*".equals(id)) {
                        camelContext.suspend();
                        continue;
                    }
                    camelContext.getRouteController().suspendRoute(id);
                    continue;
                }
                if (!"resume".equals(command)) continue;
                if ("*".equals(id)) {
                    camelContext.resume();
                    continue;
                }
                camelContext.getRouteController().resumeRoute(id);
            }
            catch (Exception e) {
                LOG.warn("Error {} route: {} due to: {}. This exception is ignored.", new Object[]{command, id, e.getMessage(), e});
            }
        }
    }
}

