/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.ArrayList;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.AsyncProcessorAwaitManager;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="blocked", displayName="Blocked Exchanges", description="Display blocked exchanges")
public class BlockedConsole
extends AbstractDevConsole {
    public BlockedConsole() {
        super("camel", "blocked", "Blocked Exchanges", "Display blocked exchanges");
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        AsyncProcessorAwaitManager am = PluginHelper.getAsyncProcessorAwaitManager((CamelContext)this.getCamelContext());
        sb.append(String.format("\n    Blocked: %s", am.size()));
        for (AsyncProcessorAwaitManager.AwaitThread at : am.browse()) {
            String age = TimeUtils.printDuration((long)at.getWaitDuration(), (boolean)true);
            sb.append(String.format("\n    %s (at: %s/%s age: %s)", at.getExchange().getExchangeId(), at.getRouteId(), at.getNodeId(), age));
        }
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        AsyncProcessorAwaitManager am = PluginHelper.getAsyncProcessorAwaitManager((CamelContext)this.getCamelContext());
        root.put((Object)"blocked", (Object)am.size());
        ArrayList<JsonObject> list = new ArrayList<JsonObject>();
        for (AsyncProcessorAwaitManager.AwaitThread at : am.browse()) {
            JsonObject props = new JsonObject();
            props.put((Object)"exchangeId", (Object)at.getExchange().getExchangeId());
            props.put((Object)"routeId", (Object)at.getRouteId());
            props.put((Object)"nodeId", (Object)at.getNodeId());
            props.put((Object)"duration", (Object)at.getWaitDuration());
            list.add(props);
        }
        if (!list.isEmpty()) {
            root.put((Object)"exchanges", list);
        }
        return root;
    }
}

