/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.ibm.watson.language.WatsonLanguageComponent;
import org.apache.camel.component.ibm.watson.language.WatsonLanguageConfiguration;
import org.apache.camel.component.ibm.watson.language.WatsonLanguageOperations;

public interface IbmWatsonLanguageComponentBuilderFactory {
    public static IbmWatsonLanguageComponentBuilder ibmWatsonLanguage() {
        return new IbmWatsonLanguageComponentBuilderImpl();
    }

    public static class IbmWatsonLanguageComponentBuilderImpl
    extends AbstractComponentBuilder<WatsonLanguageComponent>
    implements IbmWatsonLanguageComponentBuilder {
        @Override
        protected WatsonLanguageComponent buildConcreteComponent() {
            return new WatsonLanguageComponent();
        }

        private WatsonLanguageConfiguration getOrCreateConfiguration(WatsonLanguageComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new WatsonLanguageConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "serviceUrl": {
                    this.getOrCreateConfiguration((WatsonLanguageComponent)component).setServiceUrl((String)value);
                    return true;
                }
                case "analyzeCategories": {
                    this.getOrCreateConfiguration((WatsonLanguageComponent)component).setAnalyzeCategories(((Boolean)value).booleanValue());
                    return true;
                }
                case "analyzeConcepts": {
                    this.getOrCreateConfiguration((WatsonLanguageComponent)component).setAnalyzeConcepts(((Boolean)value).booleanValue());
                    return true;
                }
                case "analyzeEmotion": {
                    this.getOrCreateConfiguration((WatsonLanguageComponent)component).setAnalyzeEmotion(((Boolean)value).booleanValue());
                    return true;
                }
                case "analyzeEntities": {
                    this.getOrCreateConfiguration((WatsonLanguageComponent)component).setAnalyzeEntities(((Boolean)value).booleanValue());
                    return true;
                }
                case "analyzeKeywords": {
                    this.getOrCreateConfiguration((WatsonLanguageComponent)component).setAnalyzeKeywords(((Boolean)value).booleanValue());
                    return true;
                }
                case "analyzeSentiment": {
                    this.getOrCreateConfiguration((WatsonLanguageComponent)component).setAnalyzeSentiment(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((WatsonLanguageComponent)component).setConfiguration((WatsonLanguageConfiguration)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((WatsonLanguageComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((WatsonLanguageComponent)component).setOperation((WatsonLanguageOperations)value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((WatsonLanguageComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "healthCheckConsumerEnabled": {
                    ((WatsonLanguageComponent)component).setHealthCheckConsumerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "healthCheckProducerEnabled": {
                    ((WatsonLanguageComponent)component).setHealthCheckProducerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "apiKey": {
                    this.getOrCreateConfiguration((WatsonLanguageComponent)component).setApiKey((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface IbmWatsonLanguageComponentBuilder
    extends ComponentBuilder<WatsonLanguageComponent> {
        default public IbmWatsonLanguageComponentBuilder serviceUrl(String serviceUrl) {
            this.doSetProperty("serviceUrl", serviceUrl);
            return this;
        }

        default public IbmWatsonLanguageComponentBuilder analyzeCategories(boolean analyzeCategories) {
            this.doSetProperty("analyzeCategories", analyzeCategories);
            return this;
        }

        default public IbmWatsonLanguageComponentBuilder analyzeConcepts(boolean analyzeConcepts) {
            this.doSetProperty("analyzeConcepts", analyzeConcepts);
            return this;
        }

        default public IbmWatsonLanguageComponentBuilder analyzeEmotion(boolean analyzeEmotion) {
            this.doSetProperty("analyzeEmotion", analyzeEmotion);
            return this;
        }

        default public IbmWatsonLanguageComponentBuilder analyzeEntities(boolean analyzeEntities) {
            this.doSetProperty("analyzeEntities", analyzeEntities);
            return this;
        }

        default public IbmWatsonLanguageComponentBuilder analyzeKeywords(boolean analyzeKeywords) {
            this.doSetProperty("analyzeKeywords", analyzeKeywords);
            return this;
        }

        default public IbmWatsonLanguageComponentBuilder analyzeSentiment(boolean analyzeSentiment) {
            this.doSetProperty("analyzeSentiment", analyzeSentiment);
            return this;
        }

        default public IbmWatsonLanguageComponentBuilder configuration(WatsonLanguageConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public IbmWatsonLanguageComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public IbmWatsonLanguageComponentBuilder operation(WatsonLanguageOperations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public IbmWatsonLanguageComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public IbmWatsonLanguageComponentBuilder healthCheckConsumerEnabled(boolean healthCheckConsumerEnabled) {
            this.doSetProperty("healthCheckConsumerEnabled", healthCheckConsumerEnabled);
            return this;
        }

        default public IbmWatsonLanguageComponentBuilder healthCheckProducerEnabled(boolean healthCheckProducerEnabled) {
            this.doSetProperty("healthCheckProducerEnabled", healthCheckProducerEnabled);
            return this;
        }

        default public IbmWatsonLanguageComponentBuilder apiKey(String apiKey) {
            this.doSetProperty("apiKey", apiKey);
            return this;
        }
    }
}

