/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.textract.Textract2Component;
import org.apache.camel.component.aws2.textract.Textract2Configuration;
import org.apache.camel.component.aws2.textract.Textract2Operations;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.textract.TextractClient;

public interface Aws2TextractComponentBuilderFactory {
    public static Aws2TextractComponentBuilder aws2Textract() {
        return new Aws2TextractComponentBuilderImpl();
    }

    public static class Aws2TextractComponentBuilderImpl
    extends AbstractComponentBuilder<Textract2Component>
    implements Aws2TextractComponentBuilder {
        @Override
        protected Textract2Component buildConcreteComponent() {
            return new Textract2Component();
        }

        private Textract2Configuration getOrCreateConfiguration(Textract2Component component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new Textract2Configuration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "configuration": {
                    ((Textract2Component)component).setConfiguration((Textract2Configuration)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((Textract2Component)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((Textract2Component)component).setOperation((Textract2Operations)value);
                    return true;
                }
                case "overrideEndpoint": {
                    this.getOrCreateConfiguration((Textract2Component)component).setOverrideEndpoint(((Boolean)value).booleanValue());
                    return true;
                }
                case "pojoRequest": {
                    this.getOrCreateConfiguration((Textract2Component)component).setPojoRequest(((Boolean)value).booleanValue());
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((Textract2Component)component).setRegion((String)value);
                    return true;
                }
                case "s3Bucket": {
                    this.getOrCreateConfiguration((Textract2Component)component).setS3Bucket((String)value);
                    return true;
                }
                case "s3Object": {
                    this.getOrCreateConfiguration((Textract2Component)component).setS3Object((String)value);
                    return true;
                }
                case "s3ObjectVersion": {
                    this.getOrCreateConfiguration((Textract2Component)component).setS3ObjectVersion((String)value);
                    return true;
                }
                case "uriEndpointOverride": {
                    this.getOrCreateConfiguration((Textract2Component)component).setUriEndpointOverride((String)value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((Textract2Component)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "textractClient": {
                    this.getOrCreateConfiguration((Textract2Component)component).setTextractClient((TextractClient)value);
                    return true;
                }
                case "healthCheckConsumerEnabled": {
                    ((Textract2Component)component).setHealthCheckConsumerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "healthCheckProducerEnabled": {
                    ((Textract2Component)component).setHealthCheckProducerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((Textract2Component)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((Textract2Component)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((Textract2Component)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "accessKey": {
                    this.getOrCreateConfiguration((Textract2Component)component).setAccessKey((String)value);
                    return true;
                }
                case "profileCredentialsName": {
                    this.getOrCreateConfiguration((Textract2Component)component).setProfileCredentialsName((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((Textract2Component)component).setSecretKey((String)value);
                    return true;
                }
                case "sessionToken": {
                    this.getOrCreateConfiguration((Textract2Component)component).setSessionToken((String)value);
                    return true;
                }
                case "trustAllCertificates": {
                    this.getOrCreateConfiguration((Textract2Component)component).setTrustAllCertificates(((Boolean)value).booleanValue());
                    return true;
                }
                case "useDefaultCredentialsProvider": {
                    this.getOrCreateConfiguration((Textract2Component)component).setUseDefaultCredentialsProvider(((Boolean)value).booleanValue());
                    return true;
                }
                case "useProfileCredentialsProvider": {
                    this.getOrCreateConfiguration((Textract2Component)component).setUseProfileCredentialsProvider(((Boolean)value).booleanValue());
                    return true;
                }
                case "useSessionCredentials": {
                    this.getOrCreateConfiguration((Textract2Component)component).setUseSessionCredentials(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Aws2TextractComponentBuilder
    extends ComponentBuilder<Textract2Component> {
        default public Aws2TextractComponentBuilder configuration(Textract2Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public Aws2TextractComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Aws2TextractComponentBuilder operation(Textract2Operations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public Aws2TextractComponentBuilder overrideEndpoint(boolean overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public Aws2TextractComponentBuilder pojoRequest(boolean pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public Aws2TextractComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Aws2TextractComponentBuilder s3Bucket(String s3Bucket) {
            this.doSetProperty("s3Bucket", s3Bucket);
            return this;
        }

        default public Aws2TextractComponentBuilder s3Object(String s3Object) {
            this.doSetProperty("s3Object", s3Object);
            return this;
        }

        default public Aws2TextractComponentBuilder s3ObjectVersion(String s3ObjectVersion) {
            this.doSetProperty("s3ObjectVersion", s3ObjectVersion);
            return this;
        }

        default public Aws2TextractComponentBuilder uriEndpointOverride(String uriEndpointOverride) {
            this.doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }

        default public Aws2TextractComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public Aws2TextractComponentBuilder textractClient(TextractClient textractClient) {
            this.doSetProperty("textractClient", textractClient);
            return this;
        }

        default public Aws2TextractComponentBuilder healthCheckConsumerEnabled(boolean healthCheckConsumerEnabled) {
            this.doSetProperty("healthCheckConsumerEnabled", healthCheckConsumerEnabled);
            return this;
        }

        default public Aws2TextractComponentBuilder healthCheckProducerEnabled(boolean healthCheckProducerEnabled) {
            this.doSetProperty("healthCheckProducerEnabled", healthCheckProducerEnabled);
            return this;
        }

        default public Aws2TextractComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public Aws2TextractComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public Aws2TextractComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public Aws2TextractComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Aws2TextractComponentBuilder profileCredentialsName(String profileCredentialsName) {
            this.doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }

        default public Aws2TextractComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        default public Aws2TextractComponentBuilder sessionToken(String sessionToken) {
            this.doSetProperty("sessionToken", sessionToken);
            return this;
        }

        default public Aws2TextractComponentBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public Aws2TextractComponentBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public Aws2TextractComponentBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }

        default public Aws2TextractComponentBuilder useSessionCredentials(boolean useSessionCredentials) {
            this.doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
    }
}

