/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import io.grpc.ChannelCredentials;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.tensorflow.serving.TensorFlowServingComponent;
import org.apache.camel.component.tensorflow.serving.TensorFlowServingConfiguration;

public interface TensorflowServingComponentBuilderFactory {
    public static TensorflowServingComponentBuilder tensorflowServing() {
        return new TensorflowServingComponentBuilderImpl();
    }

    public static class TensorflowServingComponentBuilderImpl
    extends AbstractComponentBuilder<TensorFlowServingComponent>
    implements TensorflowServingComponentBuilder {
        @Override
        protected TensorFlowServingComponent buildConcreteComponent() {
            return new TensorFlowServingComponent();
        }

        private TensorFlowServingConfiguration getOrCreateConfiguration(TensorFlowServingComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new TensorFlowServingConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "configuration": {
                    ((TensorFlowServingComponent)component).setConfiguration((TensorFlowServingConfiguration)value);
                    return true;
                }
                case "modelName": {
                    this.getOrCreateConfiguration((TensorFlowServingComponent)component).setModelName((String)value);
                    return true;
                }
                case "modelVersion": {
                    this.getOrCreateConfiguration((TensorFlowServingComponent)component).setModelVersion((Long)value);
                    return true;
                }
                case "modelVersionLabel": {
                    this.getOrCreateConfiguration((TensorFlowServingComponent)component).setModelVersionLabel((String)value);
                    return true;
                }
                case "signatureName": {
                    this.getOrCreateConfiguration((TensorFlowServingComponent)component).setSignatureName((String)value);
                    return true;
                }
                case "target": {
                    this.getOrCreateConfiguration((TensorFlowServingComponent)component).setTarget((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((TensorFlowServingComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "autowiredEnabled": {
                    ((TensorFlowServingComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "credentials": {
                    this.getOrCreateConfiguration((TensorFlowServingComponent)component).setCredentials((ChannelCredentials)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface TensorflowServingComponentBuilder
    extends ComponentBuilder<TensorFlowServingComponent> {
        default public TensorflowServingComponentBuilder configuration(TensorFlowServingConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public TensorflowServingComponentBuilder modelName(String modelName) {
            this.doSetProperty("modelName", modelName);
            return this;
        }

        default public TensorflowServingComponentBuilder modelVersion(Long modelVersion) {
            this.doSetProperty("modelVersion", modelVersion);
            return this;
        }

        default public TensorflowServingComponentBuilder modelVersionLabel(String modelVersionLabel) {
            this.doSetProperty("modelVersionLabel", modelVersionLabel);
            return this;
        }

        default public TensorflowServingComponentBuilder signatureName(String signatureName) {
            this.doSetProperty("signatureName", signatureName);
            return this;
        }

        default public TensorflowServingComponentBuilder target(String target) {
            this.doSetProperty("target", target);
            return this;
        }

        default public TensorflowServingComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public TensorflowServingComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public TensorflowServingComponentBuilder credentials(ChannelCredentials credentials) {
            this.doSetProperty("credentials", credentials);
            return this;
        }
    }
}

