/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.bedrock.runtime.BedrockComponent;
import org.apache.camel.component.aws2.bedrock.runtime.BedrockConfiguration;
import org.apache.camel.component.aws2.bedrock.runtime.BedrockOperations;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClient;

public interface AwsBedrockComponentBuilderFactory {
    public static AwsBedrockComponentBuilder awsBedrock() {
        return new AwsBedrockComponentBuilderImpl();
    }

    public static class AwsBedrockComponentBuilderImpl
    extends AbstractComponentBuilder<BedrockComponent>
    implements AwsBedrockComponentBuilder {
        @Override
        protected BedrockComponent buildConcreteComponent() {
            return new BedrockComponent();
        }

        private BedrockConfiguration getOrCreateConfiguration(BedrockComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new BedrockConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "configuration": {
                    ((BedrockComponent)component).setConfiguration((BedrockConfiguration)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((BedrockComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "modelId": {
                    this.getOrCreateConfiguration((BedrockComponent)component).setModelId((String)value);
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((BedrockComponent)component).setOperation((BedrockOperations)value);
                    return true;
                }
                case "overrideEndpoint": {
                    this.getOrCreateConfiguration((BedrockComponent)component).setOverrideEndpoint(((Boolean)value).booleanValue());
                    return true;
                }
                case "pojoRequest": {
                    this.getOrCreateConfiguration((BedrockComponent)component).setPojoRequest(((Boolean)value).booleanValue());
                    return true;
                }
                case "profileCredentialsName": {
                    this.getOrCreateConfiguration((BedrockComponent)component).setProfileCredentialsName((String)value);
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((BedrockComponent)component).setRegion((String)value);
                    return true;
                }
                case "uriEndpointOverride": {
                    this.getOrCreateConfiguration((BedrockComponent)component).setUriEndpointOverride((String)value);
                    return true;
                }
                case "useDefaultCredentialsProvider": {
                    this.getOrCreateConfiguration((BedrockComponent)component).setUseDefaultCredentialsProvider(Boolean.valueOf((Boolean)value));
                    return true;
                }
                case "useProfileCredentialsProvider": {
                    this.getOrCreateConfiguration((BedrockComponent)component).setUseProfileCredentialsProvider(((Boolean)value).booleanValue());
                    return true;
                }
                case "autowiredEnabled": {
                    ((BedrockComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "bedrockRuntimeClient": {
                    this.getOrCreateConfiguration((BedrockComponent)component).setBedrockRuntimeClient((BedrockRuntimeClient)value);
                    return true;
                }
                case "healthCheckConsumerEnabled": {
                    ((BedrockComponent)component).setHealthCheckConsumerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "healthCheckProducerEnabled": {
                    ((BedrockComponent)component).setHealthCheckProducerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((BedrockComponent)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((BedrockComponent)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((BedrockComponent)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "accessKey": {
                    this.getOrCreateConfiguration((BedrockComponent)component).setAccessKey((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((BedrockComponent)component).setSecretKey((String)value);
                    return true;
                }
                case "sessionToken": {
                    this.getOrCreateConfiguration((BedrockComponent)component).setSessionToken((String)value);
                    return true;
                }
                case "trustAllCertificates": {
                    this.getOrCreateConfiguration((BedrockComponent)component).setTrustAllCertificates(((Boolean)value).booleanValue());
                    return true;
                }
                case "useSessionCredentials": {
                    this.getOrCreateConfiguration((BedrockComponent)component).setUseSessionCredentials(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface AwsBedrockComponentBuilder
    extends ComponentBuilder<BedrockComponent> {
        default public AwsBedrockComponentBuilder configuration(BedrockConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public AwsBedrockComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AwsBedrockComponentBuilder modelId(String modelId) {
            this.doSetProperty("modelId", modelId);
            return this;
        }

        default public AwsBedrockComponentBuilder operation(BedrockOperations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public AwsBedrockComponentBuilder overrideEndpoint(boolean overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public AwsBedrockComponentBuilder pojoRequest(boolean pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public AwsBedrockComponentBuilder profileCredentialsName(String profileCredentialsName) {
            this.doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }

        default public AwsBedrockComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public AwsBedrockComponentBuilder uriEndpointOverride(String uriEndpointOverride) {
            this.doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }

        default public AwsBedrockComponentBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public AwsBedrockComponentBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }

        default public AwsBedrockComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public AwsBedrockComponentBuilder bedrockRuntimeClient(BedrockRuntimeClient bedrockRuntimeClient) {
            this.doSetProperty("bedrockRuntimeClient", bedrockRuntimeClient);
            return this;
        }

        default public AwsBedrockComponentBuilder healthCheckConsumerEnabled(boolean healthCheckConsumerEnabled) {
            this.doSetProperty("healthCheckConsumerEnabled", healthCheckConsumerEnabled);
            return this;
        }

        default public AwsBedrockComponentBuilder healthCheckProducerEnabled(boolean healthCheckProducerEnabled) {
            this.doSetProperty("healthCheckProducerEnabled", healthCheckProducerEnabled);
            return this;
        }

        default public AwsBedrockComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public AwsBedrockComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public AwsBedrockComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public AwsBedrockComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public AwsBedrockComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        default public AwsBedrockComponentBuilder sessionToken(String sessionToken) {
            this.doSetProperty("sessionToken", sessionToken);
            return this;
        }

        default public AwsBedrockComponentBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public AwsBedrockComponentBuilder useSessionCredentials(boolean useSessionCredentials) {
            this.doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
    }
}

