/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.processing.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.dapr.DaprComponent;

/**
 * Dapr component which interfaces with Dapr Building Blocks.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface DaprComponentBuilderFactory {

    /**
     * Dapr (camel-dapr)
     * Dapr component which interfaces with Dapr Building Blocks.
     * 
     * Category: cloud,saas
     * Since: 4.12
     * Maven coordinates: org.apache.camel:camel-dapr
     * 
     * @return the dsl builder
     */
    static DaprComponentBuilder dapr() {
        return new DaprComponentBuilderImpl();
    }

    /**
     * Builder for the Dapr component.
     */
    interface DaprComponentBuilder extends ComponentBuilder<DaprComponent> {
    
        /**
         * List of keys for configuration operation.
         * 
         * The option is a:
         * &lt;code&gt;java.util.List&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param configKeys the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder configKeys(java.util.List<java.lang.String> configKeys) {
            doSetProperty("configKeys", configKeys);
            return this;
        }
    
        /**
         * The name of the Dapr configuration store to interact with, defined in
         * statestore.yaml config.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param configStore the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder configStore(java.lang.String configStore) {
            doSetProperty("configStore", configStore);
            return this;
        }
    
        /**
         * The component configurations.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.dapr.DaprConfiguration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder configuration(org.apache.camel.component.dapr.DaprConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
    
        /**
         * The contentType for the Pub/Sub component to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param contentType the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder contentType(java.lang.String contentType) {
            doSetProperty("contentType", contentType);
            return this;
        }
    
        /**
         * The name of the Dapr Pub/Sub component to use. This identifies which
         * underlying messaging system Dapr will interact with for publishing or
         * subscribing to events.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param pubSubName the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder pubSubName(java.lang.String pubSubName) {
            doSetProperty("pubSubName", pubSubName);
            return this;
        }
    
        /**
         * The name of the topic to subscribe to. The topic must exist in the
         * Pub/Sub component configured under the given pubsubName.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param topic the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder topic(java.lang.String topic) {
            doSetProperty("topic", topic);
            return this;
        }
    
        
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
    
        /**
         * The client to consume messages by the consumer.
         * 
         * The option is a:
         * &lt;code&gt;io.dapr.client.DaprPreviewClient&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param previewClient the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder previewClient(io.dapr.client.DaprPreviewClient previewClient) {
            doSetProperty("previewClient", previewClient);
            return this;
        }
    
        /**
         * The name of the Dapr binding to invoke.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param bindingName the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder bindingName(java.lang.String bindingName) {
            doSetProperty("bindingName", bindingName);
            return this;
        }
    
        /**
         * The operation to perform on the binding.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param bindingOperation the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder bindingOperation(java.lang.String bindingOperation) {
            doSetProperty("bindingOperation", bindingOperation);
            return this;
        }
    
        /**
         * Concurrency mode to use with state operations.
         * 
         * The option is a:
         * &lt;code&gt;io.dapr.client.domain.StateOptions.Concurrency&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param concurrency the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder concurrency(io.dapr.client.domain.StateOptions.Concurrency concurrency) {
            doSetProperty("concurrency", concurrency);
            return this;
        }
    
        /**
         * Consistency level to use with state operations.
         * 
         * The option is a:
         * &lt;code&gt;io.dapr.client.domain.StateOptions.Consistency&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param consistency the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder consistency(io.dapr.client.domain.StateOptions.Consistency consistency) {
            doSetProperty("consistency", consistency);
            return this;
        }
    
        /**
         * The eTag for optimistic concurrency during state save or delete
         * operations.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param eTag the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder eTag(java.lang.String eTag) {
            doSetProperty("eTag", eTag);
            return this;
        }
    
        /**
         * HTTP method to use when invoking the service. Accepts verbs like GET,
         * POST, PUT, DELETE, etc. Creates a minimal HttpExtension with no
         * headers or query params. Takes precedence over verb.
         * 
         * The option is a:
         * &lt;code&gt;io.dapr.client.domain.HttpExtension&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param httpExtension the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder httpExtension(io.dapr.client.domain.HttpExtension httpExtension) {
            doSetProperty("httpExtension", httpExtension);
            return this;
        }
    
        /**
         * The key used to identify the state/secret object within the specified
         * state/secret store.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param key the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder key(java.lang.String key) {
            doSetProperty("key", key);
            return this;
        }
    
        
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    
        /**
         * The name of the method or route to invoke on the target service.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param methodToInvoke the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder methodToInvoke(java.lang.String methodToInvoke) {
            doSetProperty("methodToInvoke", methodToInvoke);
            return this;
        }
    
        /**
         * The name of the Dapr secret store to interact with, defined in
         * local-secret-store.yaml config.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param secretStore the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder secretStore(java.lang.String secretStore) {
            doSetProperty("secretStore", secretStore);
            return this;
        }
    
        /**
         * Target service to invoke. Can be a Dapr App ID, a named HTTPEndpoint,
         * or a FQDN/public URL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param serviceToInvoke the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder serviceToInvoke(java.lang.String serviceToInvoke) {
            doSetProperty("serviceToInvoke", serviceToInvoke);
            return this;
        }
    
        
        /**
         * The state operation to perform on the state store. Required for
         * DaprOperation.state operation.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.dapr.StateOperation&lt;/code&gt; type.
         * 
         * Default: get
         * Group: producer
         * 
         * @param stateOperation the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder stateOperation(org.apache.camel.component.dapr.StateOperation stateOperation) {
            doSetProperty("stateOperation", stateOperation);
            return this;
        }
    
        /**
         * The name of the Dapr state store to interact with, defined in
         * statestore.yaml config.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param stateStore the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder stateStore(java.lang.String stateStore) {
            doSetProperty("stateStore", stateStore);
            return this;
        }
    
        
        /**
         * The HTTP verb to use for invoking the method.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: POST
         * Group: producer
         * 
         * @param verb the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder verb(java.lang.String verb) {
            doSetProperty("verb", verb);
            return this;
        }
    
        
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default DaprComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    }

    class DaprComponentBuilderImpl
            extends AbstractComponentBuilder<DaprComponent>
            implements DaprComponentBuilder {
        @Override
        protected DaprComponent buildConcreteComponent() {
            return new DaprComponent();
        }
        private org.apache.camel.component.dapr.DaprConfiguration getOrCreateConfiguration(DaprComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new org.apache.camel.component.dapr.DaprConfiguration());
            }
            return component.getConfiguration();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "configKeys": getOrCreateConfiguration((DaprComponent) component).setConfigKeys((java.util.List) value); return true;
            case "configStore": getOrCreateConfiguration((DaprComponent) component).setConfigStore((java.lang.String) value); return true;
            case "configuration": ((DaprComponent) component).setConfiguration((org.apache.camel.component.dapr.DaprConfiguration) value); return true;
            case "contentType": getOrCreateConfiguration((DaprComponent) component).setContentType((java.lang.String) value); return true;
            case "pubSubName": getOrCreateConfiguration((DaprComponent) component).setPubSubName((java.lang.String) value); return true;
            case "topic": getOrCreateConfiguration((DaprComponent) component).setTopic((java.lang.String) value); return true;
            case "bridgeErrorHandler": ((DaprComponent) component).setBridgeErrorHandler((boolean) value); return true;
            case "previewClient": getOrCreateConfiguration((DaprComponent) component).setPreviewClient((io.dapr.client.DaprPreviewClient) value); return true;
            case "bindingName": getOrCreateConfiguration((DaprComponent) component).setBindingName((java.lang.String) value); return true;
            case "bindingOperation": getOrCreateConfiguration((DaprComponent) component).setBindingOperation((java.lang.String) value); return true;
            case "concurrency": getOrCreateConfiguration((DaprComponent) component).setConcurrency((io.dapr.client.domain.StateOptions.Concurrency) value); return true;
            case "consistency": getOrCreateConfiguration((DaprComponent) component).setConsistency((io.dapr.client.domain.StateOptions.Consistency) value); return true;
            case "eTag": getOrCreateConfiguration((DaprComponent) component).setETag((java.lang.String) value); return true;
            case "httpExtension": getOrCreateConfiguration((DaprComponent) component).setHttpExtension((io.dapr.client.domain.HttpExtension) value); return true;
            case "key": getOrCreateConfiguration((DaprComponent) component).setKey((java.lang.String) value); return true;
            case "lazyStartProducer": ((DaprComponent) component).setLazyStartProducer((boolean) value); return true;
            case "methodToInvoke": getOrCreateConfiguration((DaprComponent) component).setMethodToInvoke((java.lang.String) value); return true;
            case "secretStore": getOrCreateConfiguration((DaprComponent) component).setSecretStore((java.lang.String) value); return true;
            case "serviceToInvoke": getOrCreateConfiguration((DaprComponent) component).setServiceToInvoke((java.lang.String) value); return true;
            case "stateOperation": getOrCreateConfiguration((DaprComponent) component).setStateOperation((org.apache.camel.component.dapr.StateOperation) value); return true;
            case "stateStore": getOrCreateConfiguration((DaprComponent) component).setStateStore((java.lang.String) value); return true;
            case "verb": getOrCreateConfiguration((DaprComponent) component).setVerb((java.lang.String) value); return true;
            case "autowiredEnabled": ((DaprComponent) component).setAutowiredEnabled((boolean) value); return true;
            default: return false;
            }
        }
    }
}