/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.solr.SolrComponent;
import org.apache.solr.client.solrj.SolrClient;

public interface SolrComponentBuilderFactory {
    public static SolrComponentBuilder solr() {
        return new SolrComponentBuilderImpl();
    }

    public static class SolrComponentBuilderImpl
    extends AbstractComponentBuilder<SolrComponent>
    implements SolrComponentBuilder {
        @Override
        protected SolrComponent buildConcreteComponent() {
            return new SolrComponent();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "connectionTimeout": {
                    ((SolrComponent)component).setConnectionTimeout(((Long)value).longValue());
                    return true;
                }
                case "defaultCollection": {
                    ((SolrComponent)component).setDefaultCollection((String)value);
                    return true;
                }
                case "host": {
                    ((SolrComponent)component).setHost((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((SolrComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "port": {
                    ((SolrComponent)component).setPort(((Integer)value).intValue());
                    return true;
                }
                case "requestTimeout": {
                    ((SolrComponent)component).setRequestTimeout(((Long)value).longValue());
                    return true;
                }
                case "autowiredEnabled": {
                    ((SolrComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "solrClient": {
                    ((SolrComponent)component).setSolrClient((SolrClient)value);
                    return true;
                }
                case "enableSSL": {
                    ((SolrComponent)component).setEnableSSL(((Boolean)value).booleanValue());
                    return true;
                }
                case "password": {
                    ((SolrComponent)component).setPassword((String)value);
                    return true;
                }
                case "username": {
                    ((SolrComponent)component).setUsername((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface SolrComponentBuilder
    extends ComponentBuilder<SolrComponent> {
        default public SolrComponentBuilder connectionTimeout(long connectionTimeout) {
            this.doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }

        default public SolrComponentBuilder defaultCollection(String defaultCollection) {
            this.doSetProperty("defaultCollection", defaultCollection);
            return this;
        }

        default public SolrComponentBuilder host(String host) {
            this.doSetProperty("host", host);
            return this;
        }

        default public SolrComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public SolrComponentBuilder port(int port) {
            this.doSetProperty("port", port);
            return this;
        }

        default public SolrComponentBuilder requestTimeout(long requestTimeout) {
            this.doSetProperty("requestTimeout", requestTimeout);
            return this;
        }

        default public SolrComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public SolrComponentBuilder solrClient(SolrClient solrClient) {
            this.doSetProperty("solrClient", solrClient);
            return this;
        }

        default public SolrComponentBuilder enableSSL(boolean enableSSL) {
            this.doSetProperty("enableSSL", enableSSL);
            return this;
        }

        default public SolrComponentBuilder password(String password) {
            this.doSetProperty("password", password);
            return this;
        }

        default public SolrComponentBuilder username(String username) {
            this.doSetProperty("username", username);
            return this;
        }
    }
}

