/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.tahu.TahuConfiguration;
import org.apache.camel.component.tahu.TahuEdgeComponent;
import org.apache.camel.support.jsse.SSLContextParameters;

public interface TahuEdgeComponentBuilderFactory {
    public static TahuEdgeComponentBuilder tahuEdge() {
        return new TahuEdgeComponentBuilderImpl();
    }

    public static class TahuEdgeComponentBuilderImpl
    extends AbstractComponentBuilder<TahuEdgeComponent>
    implements TahuEdgeComponentBuilder {
        @Override
        protected TahuEdgeComponent buildConcreteComponent() {
            return new TahuEdgeComponent();
        }

        private TahuConfiguration getOrCreateConfiguration(TahuEdgeComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new TahuConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "checkClientIdLength": {
                    this.getOrCreateConfiguration((TahuEdgeComponent)component).setCheckClientIdLength(((Boolean)value).booleanValue());
                    return true;
                }
                case "clientId": {
                    this.getOrCreateConfiguration((TahuEdgeComponent)component).setClientId((String)value);
                    return true;
                }
                case "keepAliveTimeout": {
                    this.getOrCreateConfiguration((TahuEdgeComponent)component).setKeepAliveTimeout(((Integer)value).intValue());
                    return true;
                }
                case "rebirthDebounceDelay": {
                    this.getOrCreateConfiguration((TahuEdgeComponent)component).setRebirthDebounceDelay(((Long)value).longValue());
                    return true;
                }
                case "servers": {
                    this.getOrCreateConfiguration((TahuEdgeComponent)component).setServers((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((TahuEdgeComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "autowiredEnabled": {
                    ((TahuEdgeComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((TahuEdgeComponent)component).setConfiguration((TahuConfiguration)value);
                    return true;
                }
                case "password": {
                    this.getOrCreateConfiguration((TahuEdgeComponent)component).setPassword((String)value);
                    return true;
                }
                case "sslContextParameters": {
                    this.getOrCreateConfiguration((TahuEdgeComponent)component).setSslContextParameters((SSLContextParameters)value);
                    return true;
                }
                case "useGlobalSslContextParameters": {
                    ((TahuEdgeComponent)component).setUseGlobalSslContextParameters(((Boolean)value).booleanValue());
                    return true;
                }
                case "username": {
                    this.getOrCreateConfiguration((TahuEdgeComponent)component).setUsername((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface TahuEdgeComponentBuilder
    extends ComponentBuilder<TahuEdgeComponent> {
        default public TahuEdgeComponentBuilder checkClientIdLength(boolean checkClientIdLength) {
            this.doSetProperty("checkClientIdLength", checkClientIdLength);
            return this;
        }

        default public TahuEdgeComponentBuilder clientId(String clientId) {
            this.doSetProperty("clientId", clientId);
            return this;
        }

        default public TahuEdgeComponentBuilder keepAliveTimeout(int keepAliveTimeout) {
            this.doSetProperty("keepAliveTimeout", keepAliveTimeout);
            return this;
        }

        default public TahuEdgeComponentBuilder rebirthDebounceDelay(long rebirthDebounceDelay) {
            this.doSetProperty("rebirthDebounceDelay", rebirthDebounceDelay);
            return this;
        }

        default public TahuEdgeComponentBuilder servers(String servers) {
            this.doSetProperty("servers", servers);
            return this;
        }

        default public TahuEdgeComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public TahuEdgeComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public TahuEdgeComponentBuilder configuration(TahuConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public TahuEdgeComponentBuilder password(String password) {
            this.doSetProperty("password", password);
            return this;
        }

        default public TahuEdgeComponentBuilder sslContextParameters(SSLContextParameters sslContextParameters) {
            this.doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }

        default public TahuEdgeComponentBuilder useGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
            this.doSetProperty("useGlobalSslContextParameters", useGlobalSslContextParameters);
            return this;
        }

        default public TahuEdgeComponentBuilder username(String username) {
            this.doSetProperty("username", username);
            return this;
        }
    }
}

