/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.timestream.Timestream2Component;
import org.apache.camel.component.aws2.timestream.Timestream2Configuration;
import org.apache.camel.component.aws2.timestream.Timestream2Operations;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.timestreamquery.TimestreamQueryClient;
import software.amazon.awssdk.services.timestreamwrite.TimestreamWriteClient;

public interface Aws2TimestreamComponentBuilderFactory {
    public static Aws2TimestreamComponentBuilder aws2Timestream() {
        return new Aws2TimestreamComponentBuilderImpl();
    }

    public static class Aws2TimestreamComponentBuilderImpl
    extends AbstractComponentBuilder<Timestream2Component>
    implements Aws2TimestreamComponentBuilder {
        @Override
        protected Timestream2Component buildConcreteComponent() {
            return new Timestream2Component();
        }

        private Timestream2Configuration getOrCreateConfiguration(Timestream2Component component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new Timestream2Configuration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "configuration": {
                    ((Timestream2Component)component).setConfiguration((Timestream2Configuration)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((Timestream2Component)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((Timestream2Component)component).setOperation((Timestream2Operations)value);
                    return true;
                }
                case "overrideEndpoint": {
                    this.getOrCreateConfiguration((Timestream2Component)component).setOverrideEndpoint(((Boolean)value).booleanValue());
                    return true;
                }
                case "pojoRequest": {
                    this.getOrCreateConfiguration((Timestream2Component)component).setPojoRequest(((Boolean)value).booleanValue());
                    return true;
                }
                case "profileCredentialsName": {
                    this.getOrCreateConfiguration((Timestream2Component)component).setProfileCredentialsName((String)value);
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((Timestream2Component)component).setRegion((String)value);
                    return true;
                }
                case "trustAllCertificates": {
                    this.getOrCreateConfiguration((Timestream2Component)component).setTrustAllCertificates(((Boolean)value).booleanValue());
                    return true;
                }
                case "uriEndpointOverride": {
                    this.getOrCreateConfiguration((Timestream2Component)component).setUriEndpointOverride((String)value);
                    return true;
                }
                case "useDefaultCredentialsProvider": {
                    this.getOrCreateConfiguration((Timestream2Component)component).setUseDefaultCredentialsProvider(Boolean.valueOf((Boolean)value));
                    return true;
                }
                case "useProfileCredentialsProvider": {
                    this.getOrCreateConfiguration((Timestream2Component)component).setUseProfileCredentialsProvider(((Boolean)value).booleanValue());
                    return true;
                }
                case "autowiredEnabled": {
                    ((Timestream2Component)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "awsTimestreamQueryClient": {
                    this.getOrCreateConfiguration((Timestream2Component)component).setAwsTimestreamQueryClient((TimestreamQueryClient)value);
                    return true;
                }
                case "awsTimestreamWriteClient": {
                    this.getOrCreateConfiguration((Timestream2Component)component).setAwsTimestreamWriteClient((TimestreamWriteClient)value);
                    return true;
                }
                case "healthCheckConsumerEnabled": {
                    ((Timestream2Component)component).setHealthCheckConsumerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "healthCheckProducerEnabled": {
                    ((Timestream2Component)component).setHealthCheckProducerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((Timestream2Component)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((Timestream2Component)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((Timestream2Component)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "accessKey": {
                    this.getOrCreateConfiguration((Timestream2Component)component).setAccessKey((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((Timestream2Component)component).setSecretKey((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Aws2TimestreamComponentBuilder
    extends ComponentBuilder<Timestream2Component> {
        default public Aws2TimestreamComponentBuilder configuration(Timestream2Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public Aws2TimestreamComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Aws2TimestreamComponentBuilder operation(Timestream2Operations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public Aws2TimestreamComponentBuilder overrideEndpoint(boolean overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public Aws2TimestreamComponentBuilder pojoRequest(boolean pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public Aws2TimestreamComponentBuilder profileCredentialsName(String profileCredentialsName) {
            this.doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }

        default public Aws2TimestreamComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Aws2TimestreamComponentBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public Aws2TimestreamComponentBuilder uriEndpointOverride(String uriEndpointOverride) {
            this.doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }

        default public Aws2TimestreamComponentBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public Aws2TimestreamComponentBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }

        default public Aws2TimestreamComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public Aws2TimestreamComponentBuilder awsTimestreamQueryClient(TimestreamQueryClient awsTimestreamQueryClient) {
            this.doSetProperty("awsTimestreamQueryClient", awsTimestreamQueryClient);
            return this;
        }

        default public Aws2TimestreamComponentBuilder awsTimestreamWriteClient(TimestreamWriteClient awsTimestreamWriteClient) {
            this.doSetProperty("awsTimestreamWriteClient", awsTimestreamWriteClient);
            return this;
        }

        default public Aws2TimestreamComponentBuilder healthCheckConsumerEnabled(boolean healthCheckConsumerEnabled) {
            this.doSetProperty("healthCheckConsumerEnabled", healthCheckConsumerEnabled);
            return this;
        }

        default public Aws2TimestreamComponentBuilder healthCheckProducerEnabled(boolean healthCheckProducerEnabled) {
            this.doSetProperty("healthCheckProducerEnabled", healthCheckProducerEnabled);
            return this;
        }

        default public Aws2TimestreamComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public Aws2TimestreamComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public Aws2TimestreamComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public Aws2TimestreamComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Aws2TimestreamComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }
    }
}

