/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.ExceptionListener;
import org.apache.camel.Component;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.activemq.ActiveMQComponent;
import org.apache.camel.component.jms.ConsumerType;
import org.apache.camel.component.jms.DefaultTaskExecutorType;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.component.jms.JmsKeyFormatStrategy;
import org.apache.camel.component.jms.JmsMessageType;
import org.apache.camel.component.jms.MessageCreatedStrategy;
import org.apache.camel.component.jms.MessageListenerContainerFactory;
import org.apache.camel.component.jms.QueueBrowseStrategy;
import org.apache.camel.component.jms.ReplyToType;
import org.apache.camel.component.jms.TemporaryQueueResolver;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.ErrorHandler;

public interface ActivemqComponentBuilderFactory {
    public static ActivemqComponentBuilder activemq() {
        return new ActivemqComponentBuilderImpl();
    }

    public static class ActivemqComponentBuilderImpl
    extends AbstractComponentBuilder<ActiveMQComponent>
    implements ActivemqComponentBuilder {
        @Override
        protected ActiveMQComponent buildConcreteComponent() {
            return new ActiveMQComponent();
        }

        private JmsConfiguration getOrCreateConfiguration(ActiveMQComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new JmsConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "brokerURL": {
                    ((ActiveMQComponent)component).setBrokerURL((String)value);
                    return true;
                }
                case "clientId": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setClientId((String)value);
                    return true;
                }
                case "connectionFactory": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setConnectionFactory((ConnectionFactory)value);
                    return true;
                }
                case "disableReplyTo": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setDisableReplyTo(((Boolean)value).booleanValue());
                    return true;
                }
                case "durableSubscriptionName": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setDurableSubscriptionName((String)value);
                    return true;
                }
                case "embedded": {
                    ((ActiveMQComponent)component).setEmbedded(((Boolean)value).booleanValue());
                    return true;
                }
                case "jmsMessageType": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setJmsMessageType((JmsMessageType)value);
                    return true;
                }
                case "replyTo": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setReplyTo((String)value);
                    return true;
                }
                case "testConnectionOnStartup": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setTestConnectionOnStartup(((Boolean)value).booleanValue());
                    return true;
                }
                case "usePooledConnection": {
                    ((ActiveMQComponent)component).setUsePooledConnection(((Boolean)value).booleanValue());
                    return true;
                }
                case "useSingleConnection": {
                    ((ActiveMQComponent)component).setUseSingleConnection(((Boolean)value).booleanValue());
                    return true;
                }
                case "acknowledgementModeName": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setAcknowledgementModeName((String)value);
                    return true;
                }
                case "artemisConsumerPriority": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setArtemisConsumerPriority(((Integer)value).intValue());
                    return true;
                }
                case "asyncConsumer": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setAsyncConsumer(((Boolean)value).booleanValue());
                    return true;
                }
                case "autoStartup": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setAutoStartup(((Boolean)value).booleanValue());
                    return true;
                }
                case "cacheLevel": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setCacheLevel(((Integer)value).intValue());
                    return true;
                }
                case "cacheLevelName": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setCacheLevelName((String)value);
                    return true;
                }
                case "concurrentConsumers": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setConcurrentConsumers(((Integer)value).intValue());
                    return true;
                }
                case "maxConcurrentConsumers": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setMaxConcurrentConsumers(((Integer)value).intValue());
                    return true;
                }
                case "replyToDeliveryPersistent": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setReplyToDeliveryPersistent(((Boolean)value).booleanValue());
                    return true;
                }
                case "selector": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setSelector((String)value);
                    return true;
                }
                case "subscriptionDurable": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setSubscriptionDurable(((Boolean)value).booleanValue());
                    return true;
                }
                case "subscriptionName": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setSubscriptionName((String)value);
                    return true;
                }
                case "subscriptionShared": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setSubscriptionShared(((Boolean)value).booleanValue());
                    return true;
                }
                case "acceptMessagesWhileStopping": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setAcceptMessagesWhileStopping(((Boolean)value).booleanValue());
                    return true;
                }
                case "allowReplyManagerQuickStop": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setAllowReplyManagerQuickStop(((Boolean)value).booleanValue());
                    return true;
                }
                case "consumerType": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setConsumerType((ConsumerType)value);
                    return true;
                }
                case "defaultTaskExecutorType": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setDefaultTaskExecutorType((DefaultTaskExecutorType)value);
                    return true;
                }
                case "eagerLoadingOfProperties": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setEagerLoadingOfProperties(((Boolean)value).booleanValue());
                    return true;
                }
                case "eagerPoisonBody": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setEagerPoisonBody((String)value);
                    return true;
                }
                case "exposeListenerSession": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setExposeListenerSession(((Boolean)value).booleanValue());
                    return true;
                }
                case "replyToConsumerType": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setReplyToConsumerType((ConsumerType)value);
                    return true;
                }
                case "replyToSameDestinationAllowed": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setReplyToSameDestinationAllowed(((Boolean)value).booleanValue());
                    return true;
                }
                case "taskExecutor": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setTaskExecutor((TaskExecutor)value);
                    return true;
                }
                case "deliveryDelay": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setDeliveryDelay(((Long)value).longValue());
                    return true;
                }
                case "deliveryMode": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setDeliveryMode((Integer)value);
                    return true;
                }
                case "deliveryPersistent": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setDeliveryPersistent(((Boolean)value).booleanValue());
                    return true;
                }
                case "explicitQosEnabled": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setExplicitQosEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "formatDateHeadersToIso8601": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setFormatDateHeadersToIso8601(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((ActiveMQComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "preserveMessageQos": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setPreserveMessageQos(((Boolean)value).booleanValue());
                    return true;
                }
                case "priority": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setPriority(((Integer)value).intValue());
                    return true;
                }
                case "replyToConcurrentConsumers": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setReplyToConcurrentConsumers(((Integer)value).intValue());
                    return true;
                }
                case "replyToMaxConcurrentConsumers": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setReplyToMaxConcurrentConsumers(((Integer)value).intValue());
                    return true;
                }
                case "replyToOnTimeoutMaxConcurrentConsumers": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setReplyToOnTimeoutMaxConcurrentConsumers(((Integer)value).intValue());
                    return true;
                }
                case "replyToOverride": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setReplyToOverride((String)value);
                    return true;
                }
                case "replyToType": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setReplyToType((ReplyToType)value);
                    return true;
                }
                case "requestTimeout": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setRequestTimeout(((Long)value).longValue());
                    return true;
                }
                case "timeToLive": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setTimeToLive(((Long)value).longValue());
                    return true;
                }
                case "allowAdditionalHeaders": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setAllowAdditionalHeaders((String)value);
                    return true;
                }
                case "allowNullBody": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setAllowNullBody(((Boolean)value).booleanValue());
                    return true;
                }
                case "alwaysCopyMessage": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setAlwaysCopyMessage(((Boolean)value).booleanValue());
                    return true;
                }
                case "correlationProperty": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setCorrelationProperty((String)value);
                    return true;
                }
                case "disableTimeToLive": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setDisableTimeToLive(((Boolean)value).booleanValue());
                    return true;
                }
                case "forceSendOriginalMessage": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setForceSendOriginalMessage(((Boolean)value).booleanValue());
                    return true;
                }
                case "includeSentJMSMessageID": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setIncludeSentJMSMessageID(((Boolean)value).booleanValue());
                    return true;
                }
                case "replyToCacheLevelName": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setReplyToCacheLevelName((String)value);
                    return true;
                }
                case "replyToDestinationSelectorName": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setReplyToDestinationSelectorName((String)value);
                    return true;
                }
                case "streamMessageTypeEnabled": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setStreamMessageTypeEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "allowAutoWiredConnectionFactory": {
                    ((ActiveMQComponent)component).setAllowAutoWiredConnectionFactory(((Boolean)value).booleanValue());
                    return true;
                }
                case "allowAutoWiredDestinationResolver": {
                    ((ActiveMQComponent)component).setAllowAutoWiredDestinationResolver(((Boolean)value).booleanValue());
                    return true;
                }
                case "allowSerializedHeaders": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setAllowSerializedHeaders(((Boolean)value).booleanValue());
                    return true;
                }
                case "artemisStreamingEnabled": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setArtemisStreamingEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "asyncStartListener": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setAsyncStartListener(((Boolean)value).booleanValue());
                    return true;
                }
                case "asyncStopListener": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setAsyncStopListener(((Boolean)value).booleanValue());
                    return true;
                }
                case "autowiredEnabled": {
                    ((ActiveMQComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "browseLimit": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setBrowseLimit(((Integer)value).intValue());
                    return true;
                }
                case "configuration": {
                    ((ActiveMQComponent)component).setConfiguration((JmsConfiguration)value);
                    return true;
                }
                case "destinationResolver": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setDestinationResolver((DestinationResolver)value);
                    return true;
                }
                case "errorHandler": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setErrorHandler((ErrorHandler)value);
                    return true;
                }
                case "exceptionListener": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setExceptionListener((ExceptionListener)value);
                    return true;
                }
                case "idleConsumerLimit": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setIdleConsumerLimit(((Integer)value).intValue());
                    return true;
                }
                case "idleReceivesPerTaskLimit": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setIdleReceivesPerTaskLimit(((Integer)value).intValue());
                    return true;
                }
                case "idleTaskExecutionLimit": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setIdleTaskExecutionLimit(((Integer)value).intValue());
                    return true;
                }
                case "includeAllJMSXProperties": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setIncludeAllJMSXProperties(((Boolean)value).booleanValue());
                    return true;
                }
                case "includeCorrelationIDAsBytes": {
                    ((ActiveMQComponent)component).setIncludeCorrelationIDAsBytes(((Boolean)value).booleanValue());
                    return true;
                }
                case "jmsKeyFormatStrategy": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setJmsKeyFormatStrategy((JmsKeyFormatStrategy)value);
                    return true;
                }
                case "mapJmsMessage": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setMapJmsMessage(((Boolean)value).booleanValue());
                    return true;
                }
                case "maxMessagesPerTask": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setMaxMessagesPerTask(((Integer)value).intValue());
                    return true;
                }
                case "messageConverter": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setMessageConverter((MessageConverter)value);
                    return true;
                }
                case "messageCreatedStrategy": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setMessageCreatedStrategy((MessageCreatedStrategy)value);
                    return true;
                }
                case "messageIdEnabled": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setMessageIdEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "messageListenerContainerFactory": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setMessageListenerContainerFactory((MessageListenerContainerFactory)value);
                    return true;
                }
                case "messageTimestampEnabled": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setMessageTimestampEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "pubSubNoLocal": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setPubSubNoLocal(((Boolean)value).booleanValue());
                    return true;
                }
                case "queueBrowseStrategy": {
                    ((ActiveMQComponent)component).setQueueBrowseStrategy((QueueBrowseStrategy)value);
                    return true;
                }
                case "receiveTimeout": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setReceiveTimeout(((Long)value).longValue());
                    return true;
                }
                case "recoveryInterval": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setRecoveryInterval(((Long)value).longValue());
                    return true;
                }
                case "requestTimeoutCheckerInterval": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setRequestTimeoutCheckerInterval(((Long)value).longValue());
                    return true;
                }
                case "serviceLocationEnabled": {
                    ((ActiveMQComponent)component).setServiceLocationEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "synchronous": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setSynchronous(((Boolean)value).booleanValue());
                    return true;
                }
                case "temporaryQueueResolver": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setTemporaryQueueResolver((TemporaryQueueResolver)value);
                    return true;
                }
                case "transferException": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setTransferException(((Boolean)value).booleanValue());
                    return true;
                }
                case "transferExchange": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setTransferExchange(((Boolean)value).booleanValue());
                    return true;
                }
                case "trustAllPackages": {
                    ((ActiveMQComponent)component).setTrustAllPackages(((Boolean)value).booleanValue());
                    return true;
                }
                case "useMessageIDAsCorrelationID": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setUseMessageIDAsCorrelationID(((Boolean)value).booleanValue());
                    return true;
                }
                case "waitForProvisionCorrelationToBeUpdatedCounter": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setWaitForProvisionCorrelationToBeUpdatedCounter(((Integer)value).intValue());
                    return true;
                }
                case "waitForProvisionCorrelationToBeUpdatedThreadSleepingTime": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setWaitForProvisionCorrelationToBeUpdatedThreadSleepingTime(((Long)value).longValue());
                    return true;
                }
                case "waitForTemporaryReplyToToBeUpdatedCounter": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setWaitForTemporaryReplyToToBeUpdatedCounter(((Integer)value).intValue());
                    return true;
                }
                case "waitForTemporaryReplyToToBeUpdatedThreadSleepingTime": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setWaitForTemporaryReplyToToBeUpdatedThreadSleepingTime(((Long)value).longValue());
                    return true;
                }
                case "headerFilterStrategy": {
                    ((ActiveMQComponent)component).setHeaderFilterStrategy((HeaderFilterStrategy)value);
                    return true;
                }
                case "errorHandlerLoggingLevel": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setErrorHandlerLoggingLevel((LoggingLevel)value);
                    return true;
                }
                case "errorHandlerLogStackTrace": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setErrorHandlerLogStackTrace(((Boolean)value).booleanValue());
                    return true;
                }
                case "password": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setPassword((String)value);
                    return true;
                }
                case "username": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setUsername((String)value);
                    return true;
                }
                case "transacted": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setTransacted(((Boolean)value).booleanValue());
                    return true;
                }
                case "transactedInOut": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setTransactedInOut(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyCreateTransactionManager": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setLazyCreateTransactionManager(((Boolean)value).booleanValue());
                    return true;
                }
                case "transactionManager": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setTransactionManager((PlatformTransactionManager)value);
                    return true;
                }
                case "transactionName": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setTransactionName((String)value);
                    return true;
                }
                case "transactionTimeout": {
                    this.getOrCreateConfiguration((ActiveMQComponent)component).setTransactionTimeout(((Integer)value).intValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface ActivemqComponentBuilder
    extends ComponentBuilder<ActiveMQComponent> {
        default public ActivemqComponentBuilder brokerURL(String brokerURL) {
            this.doSetProperty("brokerURL", brokerURL);
            return this;
        }

        default public ActivemqComponentBuilder clientId(String clientId) {
            this.doSetProperty("clientId", clientId);
            return this;
        }

        default public ActivemqComponentBuilder connectionFactory(ConnectionFactory connectionFactory) {
            this.doSetProperty("connectionFactory", connectionFactory);
            return this;
        }

        default public ActivemqComponentBuilder disableReplyTo(boolean disableReplyTo) {
            this.doSetProperty("disableReplyTo", disableReplyTo);
            return this;
        }

        default public ActivemqComponentBuilder durableSubscriptionName(String durableSubscriptionName) {
            this.doSetProperty("durableSubscriptionName", durableSubscriptionName);
            return this;
        }

        default public ActivemqComponentBuilder embedded(boolean embedded) {
            this.doSetProperty("embedded", embedded);
            return this;
        }

        default public ActivemqComponentBuilder jmsMessageType(JmsMessageType jmsMessageType) {
            this.doSetProperty("jmsMessageType", jmsMessageType);
            return this;
        }

        default public ActivemqComponentBuilder replyTo(String replyTo) {
            this.doSetProperty("replyTo", replyTo);
            return this;
        }

        default public ActivemqComponentBuilder testConnectionOnStartup(boolean testConnectionOnStartup) {
            this.doSetProperty("testConnectionOnStartup", testConnectionOnStartup);
            return this;
        }

        default public ActivemqComponentBuilder usePooledConnection(boolean usePooledConnection) {
            this.doSetProperty("usePooledConnection", usePooledConnection);
            return this;
        }

        default public ActivemqComponentBuilder useSingleConnection(boolean useSingleConnection) {
            this.doSetProperty("useSingleConnection", useSingleConnection);
            return this;
        }

        default public ActivemqComponentBuilder acknowledgementModeName(String acknowledgementModeName) {
            this.doSetProperty("acknowledgementModeName", acknowledgementModeName);
            return this;
        }

        default public ActivemqComponentBuilder artemisConsumerPriority(int artemisConsumerPriority) {
            this.doSetProperty("artemisConsumerPriority", artemisConsumerPriority);
            return this;
        }

        default public ActivemqComponentBuilder asyncConsumer(boolean asyncConsumer) {
            this.doSetProperty("asyncConsumer", asyncConsumer);
            return this;
        }

        default public ActivemqComponentBuilder autoStartup(boolean autoStartup) {
            this.doSetProperty("autoStartup", autoStartup);
            return this;
        }

        default public ActivemqComponentBuilder cacheLevel(int cacheLevel) {
            this.doSetProperty("cacheLevel", cacheLevel);
            return this;
        }

        default public ActivemqComponentBuilder cacheLevelName(String cacheLevelName) {
            this.doSetProperty("cacheLevelName", cacheLevelName);
            return this;
        }

        default public ActivemqComponentBuilder concurrentConsumers(int concurrentConsumers) {
            this.doSetProperty("concurrentConsumers", concurrentConsumers);
            return this;
        }

        default public ActivemqComponentBuilder maxConcurrentConsumers(int maxConcurrentConsumers) {
            this.doSetProperty("maxConcurrentConsumers", maxConcurrentConsumers);
            return this;
        }

        default public ActivemqComponentBuilder replyToDeliveryPersistent(boolean replyToDeliveryPersistent) {
            this.doSetProperty("replyToDeliveryPersistent", replyToDeliveryPersistent);
            return this;
        }

        default public ActivemqComponentBuilder selector(String selector) {
            this.doSetProperty("selector", selector);
            return this;
        }

        default public ActivemqComponentBuilder subscriptionDurable(boolean subscriptionDurable) {
            this.doSetProperty("subscriptionDurable", subscriptionDurable);
            return this;
        }

        default public ActivemqComponentBuilder subscriptionName(String subscriptionName) {
            this.doSetProperty("subscriptionName", subscriptionName);
            return this;
        }

        default public ActivemqComponentBuilder subscriptionShared(boolean subscriptionShared) {
            this.doSetProperty("subscriptionShared", subscriptionShared);
            return this;
        }

        default public ActivemqComponentBuilder acceptMessagesWhileStopping(boolean acceptMessagesWhileStopping) {
            this.doSetProperty("acceptMessagesWhileStopping", acceptMessagesWhileStopping);
            return this;
        }

        default public ActivemqComponentBuilder allowReplyManagerQuickStop(boolean allowReplyManagerQuickStop) {
            this.doSetProperty("allowReplyManagerQuickStop", allowReplyManagerQuickStop);
            return this;
        }

        default public ActivemqComponentBuilder consumerType(ConsumerType consumerType) {
            this.doSetProperty("consumerType", consumerType);
            return this;
        }

        default public ActivemqComponentBuilder defaultTaskExecutorType(DefaultTaskExecutorType defaultTaskExecutorType) {
            this.doSetProperty("defaultTaskExecutorType", defaultTaskExecutorType);
            return this;
        }

        default public ActivemqComponentBuilder eagerLoadingOfProperties(boolean eagerLoadingOfProperties) {
            this.doSetProperty("eagerLoadingOfProperties", eagerLoadingOfProperties);
            return this;
        }

        default public ActivemqComponentBuilder eagerPoisonBody(String eagerPoisonBody) {
            this.doSetProperty("eagerPoisonBody", eagerPoisonBody);
            return this;
        }

        default public ActivemqComponentBuilder exposeListenerSession(boolean exposeListenerSession) {
            this.doSetProperty("exposeListenerSession", exposeListenerSession);
            return this;
        }

        default public ActivemqComponentBuilder replyToConsumerType(ConsumerType replyToConsumerType) {
            this.doSetProperty("replyToConsumerType", replyToConsumerType);
            return this;
        }

        default public ActivemqComponentBuilder replyToSameDestinationAllowed(boolean replyToSameDestinationAllowed) {
            this.doSetProperty("replyToSameDestinationAllowed", replyToSameDestinationAllowed);
            return this;
        }

        default public ActivemqComponentBuilder taskExecutor(TaskExecutor taskExecutor) {
            this.doSetProperty("taskExecutor", taskExecutor);
            return this;
        }

        default public ActivemqComponentBuilder deliveryDelay(long deliveryDelay) {
            this.doSetProperty("deliveryDelay", deliveryDelay);
            return this;
        }

        default public ActivemqComponentBuilder deliveryMode(Integer deliveryMode) {
            this.doSetProperty("deliveryMode", deliveryMode);
            return this;
        }

        default public ActivemqComponentBuilder deliveryPersistent(boolean deliveryPersistent) {
            this.doSetProperty("deliveryPersistent", deliveryPersistent);
            return this;
        }

        default public ActivemqComponentBuilder explicitQosEnabled(Boolean explicitQosEnabled) {
            this.doSetProperty("explicitQosEnabled", explicitQosEnabled);
            return this;
        }

        default public ActivemqComponentBuilder formatDateHeadersToIso8601(boolean formatDateHeadersToIso8601) {
            this.doSetProperty("formatDateHeadersToIso8601", formatDateHeadersToIso8601);
            return this;
        }

        default public ActivemqComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public ActivemqComponentBuilder preserveMessageQos(boolean preserveMessageQos) {
            this.doSetProperty("preserveMessageQos", preserveMessageQos);
            return this;
        }

        default public ActivemqComponentBuilder priority(int priority) {
            this.doSetProperty("priority", priority);
            return this;
        }

        default public ActivemqComponentBuilder replyToConcurrentConsumers(int replyToConcurrentConsumers) {
            this.doSetProperty("replyToConcurrentConsumers", replyToConcurrentConsumers);
            return this;
        }

        default public ActivemqComponentBuilder replyToMaxConcurrentConsumers(int replyToMaxConcurrentConsumers) {
            this.doSetProperty("replyToMaxConcurrentConsumers", replyToMaxConcurrentConsumers);
            return this;
        }

        default public ActivemqComponentBuilder replyToOnTimeoutMaxConcurrentConsumers(int replyToOnTimeoutMaxConcurrentConsumers) {
            this.doSetProperty("replyToOnTimeoutMaxConcurrentConsumers", replyToOnTimeoutMaxConcurrentConsumers);
            return this;
        }

        default public ActivemqComponentBuilder replyToOverride(String replyToOverride) {
            this.doSetProperty("replyToOverride", replyToOverride);
            return this;
        }

        default public ActivemqComponentBuilder replyToType(ReplyToType replyToType) {
            this.doSetProperty("replyToType", replyToType);
            return this;
        }

        default public ActivemqComponentBuilder requestTimeout(long requestTimeout) {
            this.doSetProperty("requestTimeout", requestTimeout);
            return this;
        }

        default public ActivemqComponentBuilder timeToLive(long timeToLive) {
            this.doSetProperty("timeToLive", timeToLive);
            return this;
        }

        default public ActivemqComponentBuilder allowAdditionalHeaders(String allowAdditionalHeaders) {
            this.doSetProperty("allowAdditionalHeaders", allowAdditionalHeaders);
            return this;
        }

        default public ActivemqComponentBuilder allowNullBody(boolean allowNullBody) {
            this.doSetProperty("allowNullBody", allowNullBody);
            return this;
        }

        default public ActivemqComponentBuilder alwaysCopyMessage(boolean alwaysCopyMessage) {
            this.doSetProperty("alwaysCopyMessage", alwaysCopyMessage);
            return this;
        }

        default public ActivemqComponentBuilder correlationProperty(String correlationProperty) {
            this.doSetProperty("correlationProperty", correlationProperty);
            return this;
        }

        default public ActivemqComponentBuilder disableTimeToLive(boolean disableTimeToLive) {
            this.doSetProperty("disableTimeToLive", disableTimeToLive);
            return this;
        }

        default public ActivemqComponentBuilder forceSendOriginalMessage(boolean forceSendOriginalMessage) {
            this.doSetProperty("forceSendOriginalMessage", forceSendOriginalMessage);
            return this;
        }

        default public ActivemqComponentBuilder includeSentJMSMessageID(boolean includeSentJMSMessageID) {
            this.doSetProperty("includeSentJMSMessageID", includeSentJMSMessageID);
            return this;
        }

        default public ActivemqComponentBuilder replyToCacheLevelName(String replyToCacheLevelName) {
            this.doSetProperty("replyToCacheLevelName", replyToCacheLevelName);
            return this;
        }

        default public ActivemqComponentBuilder replyToDestinationSelectorName(String replyToDestinationSelectorName) {
            this.doSetProperty("replyToDestinationSelectorName", replyToDestinationSelectorName);
            return this;
        }

        default public ActivemqComponentBuilder streamMessageTypeEnabled(boolean streamMessageTypeEnabled) {
            this.doSetProperty("streamMessageTypeEnabled", streamMessageTypeEnabled);
            return this;
        }

        default public ActivemqComponentBuilder allowAutoWiredConnectionFactory(boolean allowAutoWiredConnectionFactory) {
            this.doSetProperty("allowAutoWiredConnectionFactory", allowAutoWiredConnectionFactory);
            return this;
        }

        default public ActivemqComponentBuilder allowAutoWiredDestinationResolver(boolean allowAutoWiredDestinationResolver) {
            this.doSetProperty("allowAutoWiredDestinationResolver", allowAutoWiredDestinationResolver);
            return this;
        }

        default public ActivemqComponentBuilder allowSerializedHeaders(boolean allowSerializedHeaders) {
            this.doSetProperty("allowSerializedHeaders", allowSerializedHeaders);
            return this;
        }

        default public ActivemqComponentBuilder artemisStreamingEnabled(boolean artemisStreamingEnabled) {
            this.doSetProperty("artemisStreamingEnabled", artemisStreamingEnabled);
            return this;
        }

        default public ActivemqComponentBuilder asyncStartListener(boolean asyncStartListener) {
            this.doSetProperty("asyncStartListener", asyncStartListener);
            return this;
        }

        default public ActivemqComponentBuilder asyncStopListener(boolean asyncStopListener) {
            this.doSetProperty("asyncStopListener", asyncStopListener);
            return this;
        }

        default public ActivemqComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public ActivemqComponentBuilder browseLimit(int browseLimit) {
            this.doSetProperty("browseLimit", browseLimit);
            return this;
        }

        default public ActivemqComponentBuilder configuration(JmsConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public ActivemqComponentBuilder destinationResolver(DestinationResolver destinationResolver) {
            this.doSetProperty("destinationResolver", destinationResolver);
            return this;
        }

        default public ActivemqComponentBuilder errorHandler(ErrorHandler errorHandler) {
            this.doSetProperty("errorHandler", errorHandler);
            return this;
        }

        default public ActivemqComponentBuilder exceptionListener(ExceptionListener exceptionListener) {
            this.doSetProperty("exceptionListener", exceptionListener);
            return this;
        }

        default public ActivemqComponentBuilder idleConsumerLimit(int idleConsumerLimit) {
            this.doSetProperty("idleConsumerLimit", idleConsumerLimit);
            return this;
        }

        default public ActivemqComponentBuilder idleReceivesPerTaskLimit(int idleReceivesPerTaskLimit) {
            this.doSetProperty("idleReceivesPerTaskLimit", idleReceivesPerTaskLimit);
            return this;
        }

        default public ActivemqComponentBuilder idleTaskExecutionLimit(int idleTaskExecutionLimit) {
            this.doSetProperty("idleTaskExecutionLimit", idleTaskExecutionLimit);
            return this;
        }

        default public ActivemqComponentBuilder includeAllJMSXProperties(boolean includeAllJMSXProperties) {
            this.doSetProperty("includeAllJMSXProperties", includeAllJMSXProperties);
            return this;
        }

        default public ActivemqComponentBuilder includeCorrelationIDAsBytes(boolean includeCorrelationIDAsBytes) {
            this.doSetProperty("includeCorrelationIDAsBytes", includeCorrelationIDAsBytes);
            return this;
        }

        default public ActivemqComponentBuilder jmsKeyFormatStrategy(JmsKeyFormatStrategy jmsKeyFormatStrategy) {
            this.doSetProperty("jmsKeyFormatStrategy", jmsKeyFormatStrategy);
            return this;
        }

        default public ActivemqComponentBuilder mapJmsMessage(boolean mapJmsMessage) {
            this.doSetProperty("mapJmsMessage", mapJmsMessage);
            return this;
        }

        default public ActivemqComponentBuilder maxMessagesPerTask(int maxMessagesPerTask) {
            this.doSetProperty("maxMessagesPerTask", maxMessagesPerTask);
            return this;
        }

        default public ActivemqComponentBuilder messageConverter(MessageConverter messageConverter) {
            this.doSetProperty("messageConverter", messageConverter);
            return this;
        }

        default public ActivemqComponentBuilder messageCreatedStrategy(MessageCreatedStrategy messageCreatedStrategy) {
            this.doSetProperty("messageCreatedStrategy", messageCreatedStrategy);
            return this;
        }

        default public ActivemqComponentBuilder messageIdEnabled(boolean messageIdEnabled) {
            this.doSetProperty("messageIdEnabled", messageIdEnabled);
            return this;
        }

        default public ActivemqComponentBuilder messageListenerContainerFactory(MessageListenerContainerFactory messageListenerContainerFactory) {
            this.doSetProperty("messageListenerContainerFactory", messageListenerContainerFactory);
            return this;
        }

        default public ActivemqComponentBuilder messageTimestampEnabled(boolean messageTimestampEnabled) {
            this.doSetProperty("messageTimestampEnabled", messageTimestampEnabled);
            return this;
        }

        default public ActivemqComponentBuilder pubSubNoLocal(boolean pubSubNoLocal) {
            this.doSetProperty("pubSubNoLocal", pubSubNoLocal);
            return this;
        }

        default public ActivemqComponentBuilder queueBrowseStrategy(QueueBrowseStrategy queueBrowseStrategy) {
            this.doSetProperty("queueBrowseStrategy", queueBrowseStrategy);
            return this;
        }

        default public ActivemqComponentBuilder receiveTimeout(long receiveTimeout) {
            this.doSetProperty("receiveTimeout", receiveTimeout);
            return this;
        }

        default public ActivemqComponentBuilder recoveryInterval(long recoveryInterval) {
            this.doSetProperty("recoveryInterval", recoveryInterval);
            return this;
        }

        default public ActivemqComponentBuilder requestTimeoutCheckerInterval(long requestTimeoutCheckerInterval) {
            this.doSetProperty("requestTimeoutCheckerInterval", requestTimeoutCheckerInterval);
            return this;
        }

        default public ActivemqComponentBuilder serviceLocationEnabled(boolean serviceLocationEnabled) {
            this.doSetProperty("serviceLocationEnabled", serviceLocationEnabled);
            return this;
        }

        default public ActivemqComponentBuilder synchronous(boolean synchronous) {
            this.doSetProperty("synchronous", synchronous);
            return this;
        }

        default public ActivemqComponentBuilder temporaryQueueResolver(TemporaryQueueResolver temporaryQueueResolver) {
            this.doSetProperty("temporaryQueueResolver", temporaryQueueResolver);
            return this;
        }

        default public ActivemqComponentBuilder transferException(boolean transferException) {
            this.doSetProperty("transferException", transferException);
            return this;
        }

        default public ActivemqComponentBuilder transferExchange(boolean transferExchange) {
            this.doSetProperty("transferExchange", transferExchange);
            return this;
        }

        default public ActivemqComponentBuilder trustAllPackages(boolean trustAllPackages) {
            this.doSetProperty("trustAllPackages", trustAllPackages);
            return this;
        }

        default public ActivemqComponentBuilder useMessageIDAsCorrelationID(boolean useMessageIDAsCorrelationID) {
            this.doSetProperty("useMessageIDAsCorrelationID", useMessageIDAsCorrelationID);
            return this;
        }

        default public ActivemqComponentBuilder waitForProvisionCorrelationToBeUpdatedCounter(int waitForProvisionCorrelationToBeUpdatedCounter) {
            this.doSetProperty("waitForProvisionCorrelationToBeUpdatedCounter", waitForProvisionCorrelationToBeUpdatedCounter);
            return this;
        }

        default public ActivemqComponentBuilder waitForProvisionCorrelationToBeUpdatedThreadSleepingTime(long waitForProvisionCorrelationToBeUpdatedThreadSleepingTime) {
            this.doSetProperty("waitForProvisionCorrelationToBeUpdatedThreadSleepingTime", waitForProvisionCorrelationToBeUpdatedThreadSleepingTime);
            return this;
        }

        default public ActivemqComponentBuilder waitForTemporaryReplyToToBeUpdatedCounter(int waitForTemporaryReplyToToBeUpdatedCounter) {
            this.doSetProperty("waitForTemporaryReplyToToBeUpdatedCounter", waitForTemporaryReplyToToBeUpdatedCounter);
            return this;
        }

        default public ActivemqComponentBuilder waitForTemporaryReplyToToBeUpdatedThreadSleepingTime(long waitForTemporaryReplyToToBeUpdatedThreadSleepingTime) {
            this.doSetProperty("waitForTemporaryReplyToToBeUpdatedThreadSleepingTime", waitForTemporaryReplyToToBeUpdatedThreadSleepingTime);
            return this;
        }

        default public ActivemqComponentBuilder headerFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
            this.doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }

        default public ActivemqComponentBuilder errorHandlerLoggingLevel(LoggingLevel errorHandlerLoggingLevel) {
            this.doSetProperty("errorHandlerLoggingLevel", errorHandlerLoggingLevel);
            return this;
        }

        default public ActivemqComponentBuilder errorHandlerLogStackTrace(boolean errorHandlerLogStackTrace) {
            this.doSetProperty("errorHandlerLogStackTrace", errorHandlerLogStackTrace);
            return this;
        }

        default public ActivemqComponentBuilder password(String password) {
            this.doSetProperty("password", password);
            return this;
        }

        default public ActivemqComponentBuilder username(String username) {
            this.doSetProperty("username", username);
            return this;
        }

        default public ActivemqComponentBuilder transacted(boolean transacted) {
            this.doSetProperty("transacted", transacted);
            return this;
        }

        default public ActivemqComponentBuilder transactedInOut(boolean transactedInOut) {
            this.doSetProperty("transactedInOut", transactedInOut);
            return this;
        }

        default public ActivemqComponentBuilder lazyCreateTransactionManager(boolean lazyCreateTransactionManager) {
            this.doSetProperty("lazyCreateTransactionManager", lazyCreateTransactionManager);
            return this;
        }

        default public ActivemqComponentBuilder transactionManager(PlatformTransactionManager transactionManager) {
            this.doSetProperty("transactionManager", transactionManager);
            return this;
        }

        default public ActivemqComponentBuilder transactionName(String transactionName) {
            this.doSetProperty("transactionName", transactionName);
            return this;
        }

        default public ActivemqComponentBuilder transactionTimeout(int transactionTimeout) {
            this.doSetProperty("transactionTimeout", transactionTimeout);
            return this;
        }
    }
}

