/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.clickup;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.clickup.model.Event;
import org.apache.camel.component.clickup.service.ClickUpWebhookService;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.AsyncProcessorSupport;

public class ClickUpWebhookProcessor
extends AsyncProcessorSupport {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final AsyncProcessor nextProcessor;
    private final ClickUpWebhookService clickUpWebhookService;
    private String webhookSecret;

    public ClickUpWebhookProcessor(Processor nextProcessor, ClickUpWebhookService clickUpWebhookService, String webhookSecret) {
        this.nextProcessor = AsyncProcessorConverterHelper.convert((Processor)nextProcessor);
        this.clickUpWebhookService = clickUpWebhookService;
        this.webhookSecret = webhookSecret;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        Event event;
        Message incomingMessage = exchange.getIn();
        try {
            this.clickUpWebhookService.validateMessageSignature(incomingMessage, this.webhookSecret);
        }
        catch (RuntimeException e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
        try (InputStream body = (InputStream)exchange.getIn().getBody(InputStream.class);){
            event = (Event)MAPPER.readValue(body, Event.class);
        }
        catch (IOException e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
        exchange.getMessage().setBody((Object)event);
        return this.nextProcessor.process(exchange, doneSync -> {
            exchange.getMessage().setBody(null);
            callback.done(doneSync);
        });
    }

    public void setWebhookSecret(String webhookSecret) {
        this.webhookSecret = webhookSecret;
    }
}

