/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box.api;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxComment;
import com.box.sdk.BoxFile;
import java.util.List;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.box.api.BoxHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoxCommentsManager {
    private static final Logger LOG = LoggerFactory.getLogger(BoxCommentsManager.class);
    private BoxAPIConnection boxConnection;

    public BoxCommentsManager(BoxAPIConnection boxConnection) {
        this.boxConnection = boxConnection;
    }

    public BoxFile addFileComment(String fileId, String message) {
        try {
            LOG.debug("Adding comment to file(id={}) to '{}'", (Object)fileId, (Object)message);
            BoxHelper.notNull(fileId, "fileId");
            BoxHelper.notNull(message, "message");
            BoxFile fileToCommentOn = new BoxFile(this.boxConnection, fileId);
            fileToCommentOn.addComment(message);
            return fileToCommentOn;
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), (Throwable)e);
        }
    }

    public List<BoxComment.Info> getFileComments(String fileId) {
        try {
            LOG.debug("Getting comments of file(id={})", (Object)fileId);
            BoxHelper.notNull(fileId, "fileId");
            BoxFile file = new BoxFile(this.boxConnection, fileId);
            return file.getComments();
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), (Throwable)e);
        }
    }

    public BoxComment.Info getCommentInfo(String commentId) {
        try {
            LOG.debug("Getting info for comment(id={})", (Object)commentId);
            BoxHelper.notNull(commentId, "commentId");
            BoxComment comment = new BoxComment(this.boxConnection, commentId);
            return comment.getInfo();
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), (Throwable)e);
        }
    }

    public BoxComment replyToComment(String commentId, String message) {
        try {
            LOG.debug("Replying to comment(id={}) with message={}", (Object)commentId, (Object)message);
            BoxHelper.notNull(commentId, "commentId");
            BoxHelper.notNull(message, "message");
            BoxComment comment = new BoxComment(this.boxConnection, commentId);
            return comment.reply(message).getResource();
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), (Throwable)e);
        }
    }

    public BoxComment changeCommentMessage(String commentId, String message) {
        try {
            LOG.debug("Changing comment(id={}) message={}", (Object)commentId, (Object)message);
            BoxHelper.notNull(commentId, "commentId");
            BoxHelper.notNull(message, "message");
            BoxComment comment = new BoxComment(this.boxConnection, commentId);
            return comment.changeMessage(message).getResource();
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), (Throwable)e);
        }
    }

    public void deleteComment(String commentId) {
        try {
            LOG.debug("Deleting comment(id={})", (Object)commentId);
            BoxHelper.notNull(commentId, "commentId");
            BoxComment comment = new BoxComment(this.boxConnection, commentId);
            comment.delete();
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxHelper.buildBoxApiErrorMessage(e), (Throwable)e);
        }
    }
}

