/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box.api;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxGroup;
import com.box.sdk.BoxGroupMembership;
import com.box.sdk.BoxUser;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.box.api.BoxHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoxGroupsManager {
    private static final Logger LOG = LoggerFactory.getLogger(BoxGroupsManager.class);
    private BoxAPIConnection boxConnection;

    public BoxGroupsManager(BoxAPIConnection boxConnection) {
        this.boxConnection = boxConnection;
    }

    public Collection<BoxGroup> getAllGroups() {
        try {
            LOG.debug("Getting all groups");
            ArrayList<BoxGroup> groups = new ArrayList<BoxGroup>();
            for (BoxGroup.Info groupInfo : BoxGroup.getAllGroups((BoxAPIConnection)this.boxConnection)) {
                groups.add(groupInfo.getResource());
            }
            return groups;
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxGroupsManager.buildBoxApiErrorMessage(e), (Throwable)e);
        }
    }

    private static String buildBoxApiErrorMessage(BoxAPIException e) {
        return String.format("Box API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse());
    }

    public BoxGroup createGroup(String name, String provenance, String externalSyncIdentifier, String description, String invitabilityLevel, String memberViewabilityLevel) {
        try {
            LOG.debug("Creating group name={}", (Object)name);
            if (name == null) {
                throw new IllegalArgumentException("Parameter 'name' can not be null");
            }
            return BoxGroup.createGroup((BoxAPIConnection)this.boxConnection, (String)name, (String)provenance, (String)externalSyncIdentifier, (String)description, (String)invitabilityLevel, (String)memberViewabilityLevel).getResource();
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxGroupsManager.buildBoxApiErrorMessage(e), (Throwable)e);
        }
    }

    public void deleteGroup(String groupId) {
        try {
            LOG.debug("Deleting group({})", (Object)groupId);
            BoxHelper.notNull(groupId, "groupId");
            BoxGroup group = new BoxGroup(this.boxConnection, groupId);
            group.delete();
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxGroupsManager.buildBoxApiErrorMessage(e), (Throwable)e);
        }
    }

    public BoxGroup.Info getGroupInfo(String groupId) {
        try {
            LOG.debug("Getting info for group(id={})", (Object)groupId);
            BoxHelper.notNull(groupId, "groupId");
            BoxGroup group = new BoxGroup(this.boxConnection, groupId);
            return group.getInfo(new String[0]);
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxGroupsManager.buildBoxApiErrorMessage(e), (Throwable)e);
        }
    }

    public BoxGroup updateGroupInfo(String groupId, BoxGroup.Info groupInfo) {
        try {
            LOG.debug("Updating info for group(id={})", (Object)groupId);
            BoxHelper.notNull(groupId, "groupId");
            BoxHelper.notNull(groupInfo, "groupInfo");
            BoxGroup group = new BoxGroup(this.boxConnection, groupId);
            group.updateInfo(groupInfo);
            return group;
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxGroupsManager.buildBoxApiErrorMessage(e), (Throwable)e);
        }
    }

    public Collection<BoxGroupMembership.Info> getGroupMemberships(String groupId) {
        try {
            LOG.debug("Getting information about all memberships for group(id={})", (Object)groupId);
            BoxHelper.notNull(groupId, "groupId");
            BoxGroup group = new BoxGroup(this.boxConnection, groupId);
            return group.getMemberships();
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxGroupsManager.buildBoxApiErrorMessage(e), (Throwable)e);
        }
    }

    public BoxGroupMembership addGroupMembership(String groupId, String userId, BoxGroupMembership.GroupRole role) {
        try {
            LOG.debug("Adding user(id={}) as member to group(id={} {})", new Object[]{userId, groupId, role == null ? "" : "with role=" + role.name()});
            BoxHelper.notNull(groupId, "groupId");
            BoxHelper.notNull(userId, "userId");
            BoxGroup group = new BoxGroup(this.boxConnection, groupId);
            BoxUser user = new BoxUser(this.boxConnection, userId);
            return group.addMembership(user, role).getResource();
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxGroupsManager.buildBoxApiErrorMessage(e), (Throwable)e);
        }
    }

    public void deleteGroupMembership(String groupMembershipId) {
        try {
            LOG.debug("Deleting groupMembership(id={})", (Object)groupMembershipId);
            BoxHelper.notNull(groupMembershipId, "groupMembershipId");
            BoxGroupMembership groupMembership = new BoxGroupMembership(this.boxConnection, groupMembershipId);
            groupMembership.delete();
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxGroupsManager.buildBoxApiErrorMessage(e), (Throwable)e);
        }
    }

    public BoxGroupMembership.Info getGroupMembershipInfo(String groupMembershipId) {
        try {
            LOG.debug("Getting info for groupMemebership(id={})", (Object)groupMembershipId);
            BoxHelper.notNull(groupMembershipId, "groupMembershipId");
            BoxGroupMembership group = new BoxGroupMembership(this.boxConnection, groupMembershipId);
            return group.getInfo();
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxGroupsManager.buildBoxApiErrorMessage(e), (Throwable)e);
        }
    }

    public BoxGroupMembership updateGroupMembershipInfo(String groupMembershipId, BoxGroupMembership.Info info) {
        try {
            LOG.debug("Updating info for groupMembership(id={})", (Object)groupMembershipId);
            BoxHelper.notNull(groupMembershipId, "groupMembershipId");
            BoxHelper.notNull(info, "info");
            BoxGroupMembership groupMembership = new BoxGroupMembership(this.boxConnection, groupMembershipId);
            groupMembership.updateInfo(info);
            return groupMembership;
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(BoxGroupsManager.buildBoxApiErrorMessage(e), (Throwable)e);
        }
    }
}

