/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.IOException;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.SendDynamicAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendDynamicAwareResolver {
    public static final String RESOURCE_PATH = "META-INF/services/org/apache/camel/send-dynamic/";
    private static final Logger LOG = LoggerFactory.getLogger(SendDynamicAwareResolver.class);
    private FactoryFinder factoryFinder;

    public SendDynamicAware resolve(CamelContext context, String scheme) {
        String name = scheme;
        Class<?> type = null;
        try {
            type = this.findFactory(name, context);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (type != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found SendDynamicAware: {} via: {}{}", new Object[]{type.getName(), this.factoryFinder.getResourcePath(), name});
            }
            if (SendDynamicAware.class.isAssignableFrom(type)) {
                SendDynamicAware answer = (SendDynamicAware)context.getInjector().newInstance(type, false);
                answer.setScheme(scheme);
                return answer;
            }
            throw new IllegalArgumentException("Type is not a SendDynamicAware implementation. Found: " + type.getName());
        }
        return null;
    }

    private Class<?> findFactory(String name, CamelContext context) throws IOException {
        if (this.factoryFinder == null) {
            this.factoryFinder = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getFactoryFinder(RESOURCE_PATH);
        }
        return this.factoryFinder.findClass(name).orElse(null);
    }
}

