/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.IsSingleton;
import org.apache.camel.Route;
import org.apache.camel.RouteAware;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.StartupListener;
import org.apache.camel.TypeConverter;
import org.apache.camel.impl.engine.DeferServiceStartupListener;
import org.apache.camel.impl.engine.InternalRouteStartupManager;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.EventHelper;
import org.apache.camel.support.service.BaseService;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class InternalServiceManager {
    private static final Logger LOG = LoggerFactory.getLogger(InternalServiceManager.class);
    private final CamelContext camelContext;
    private final InternalRouteStartupManager internalRouteStartupManager;
    private final DeferServiceStartupListener deferStartupListener = new DeferServiceStartupListener();
    private final List<Service> services = new CopyOnWriteArrayList<Service>();

    InternalServiceManager(CamelContext camelContext, InternalRouteStartupManager internalRouteStartupManager, List<StartupListener> startupListeners) {
        assert (camelContext != null) : "the Camel context cannot be null";
        assert (internalRouteStartupManager != null) : "the internalRouteStartupManager cannot be null";
        assert (startupListeners != null) : "the startupListeners cannot be null";
        this.camelContext = camelContext;
        this.internalRouteStartupManager = internalRouteStartupManager;
        startupListeners.add(this.deferStartupListener);
    }

    public <T> T addService(T object) {
        return this.addService(object, true);
    }

    public <T> T addService(T object, boolean stopOnShutdown) {
        return this.addService(object, stopOnShutdown, true, true);
    }

    public <T> T addService(T object, boolean stopOnShutdown, boolean forceStart, boolean useLifecycleStrategies) {
        try {
            this.doAddService(object, stopOnShutdown, forceStart, useLifecycleStrategies);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        return object;
    }

    public void doAddService(Object object, boolean stopOnShutdown, boolean forceStart, boolean useLifecycleStrategies) throws Exception {
        if (object == null) {
            return;
        }
        CamelContextAware.trySetCamelContext((Object)object, (CamelContext)this.camelContext);
        if (object instanceof Service) {
            Service service = (Service)object;
            if (useLifecycleStrategies) {
                for (LifecycleStrategy strategy : this.camelContext.getLifecycleStrategies()) {
                    if (service instanceof Endpoint) {
                        strategy.onEndpointAdd((Endpoint)service);
                        continue;
                    }
                    Route route = service instanceof RouteAware ? ((RouteAware)service).getRoute() : this.internalRouteStartupManager.getSetupRoute();
                    strategy.onServiceAdd(this.camelContext, service, route);
                }
            }
            if (!forceStart) {
                ServiceHelper.initService((Object)service);
                this.camelContext.deferStartService(object, stopOnShutdown);
            } else {
                CamelContext camelContext;
                boolean singleton = true;
                if (object instanceof IsSingleton) {
                    singleton = ((IsSingleton)service).isSingleton();
                }
                if (singleton && !(service instanceof Endpoint) && stopOnShutdown && !this.camelContext.hasService((Object)service)) {
                    boolean tc;
                    boolean bl = tc = service instanceof TypeConverter || service instanceof TypeConverterRegistry;
                    if (!tc) {
                        this.services.add(service);
                    }
                }
                if ((camelContext = this.camelContext) instanceof BaseService) {
                    BaseService baseService = (BaseService)camelContext;
                    if (baseService.isStartingOrStarted()) {
                        ServiceHelper.startService((Object)service);
                    } else {
                        ServiceHelper.initService((Object)service);
                        this.deferStartService(object, stopOnShutdown, true);
                    }
                }
            }
        }
    }

    public void deferStartService(Object object, boolean stopOnShutdown, boolean startEarly) {
        if (object instanceof Service) {
            Service service = (Service)object;
            boolean singleton = true;
            if (object instanceof IsSingleton) {
                singleton = ((IsSingleton)service).isSingleton();
            }
            if (singleton && !(service instanceof Endpoint) && stopOnShutdown && !this.camelContext.hasService((Object)service)) {
                this.services.add(service);
            }
            if (this.camelContext.isStarted()) {
                ServiceHelper.startService((Object)service);
            } else {
                this.deferStartupListener.addService(service, startEarly);
            }
        }
    }

    public boolean removeService(Service service) {
        return this.services.remove(service);
    }

    public <T> Set<T> hasServices(Class<T> type) {
        if (this.services.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Service> set = new HashSet<Service>();
        for (Service service : this.services) {
            if (!type.isInstance(service)) continue;
            set.add(service);
        }
        return set;
    }

    public boolean hasService(Object object) {
        if (this.services.isEmpty()) {
            return false;
        }
        if (object instanceof Service) {
            Service service = (Service)object;
            return this.services.contains(service);
        }
        return false;
    }

    public <T> T hasService(Class<T> type) {
        if (this.services.isEmpty()) {
            return null;
        }
        for (Service service : this.services) {
            if (!type.isInstance(service)) continue;
            return type.cast(service);
        }
        return null;
    }

    public void stopConsumers() {
        for (Service service : this.services) {
            if (!(service instanceof Consumer)) continue;
            InternalServiceManager.shutdownServices(this.camelContext, service);
        }
    }

    public void shutdownServices() {
        InternalServiceManager.shutdownServices(this.camelContext, this.services);
        this.services.clear();
    }

    public static void shutdownServices(CamelContext camelContext, Collection<?> services) {
        InternalServiceManager.shutdownServices(camelContext, services, true);
    }

    public List<Service> getServices() {
        return Collections.unmodifiableList(this.services);
    }

    public static void shutdownServices(CamelContext camelContext, Collection<?> services, boolean reverse) {
        Collection<?> list = services;
        if (reverse) {
            ArrayList reverseList = new ArrayList(services);
            Collections.reverse(reverseList);
            list = reverseList;
        }
        for (Object service : list) {
            InternalServiceManager.shutdownServices(camelContext, service);
        }
    }

    public static void shutdownServices(CamelContext camelContext, Object service) {
        try {
            if (service instanceof Service) {
                ServiceHelper.stopAndShutdownService((Object)service);
            } else if (service instanceof Collection) {
                ServiceHelper.stopAndShutdownServices((Collection)((Collection)service));
            }
        }
        catch (Exception e) {
            LOG.warn("Error occurred while shutting down service: {}. This exception will be ignored.", service, (Object)e);
            EventHelper.notifyServiceStopFailure((CamelContext)camelContext, (Object)service, (Throwable)e);
        }
    }
}

