/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.FailedToStartRouteException;
import org.apache.camel.LoggingLevel;
import org.apache.camel.MultipleConsumersSupport;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.ServiceStatus;
import org.apache.camel.StartupListener;
import org.apache.camel.StartupStep;
import org.apache.camel.StatefulService;
import org.apache.camel.SuspendableService;
import org.apache.camel.impl.engine.AbstractCamelContext;
import org.apache.camel.impl.engine.DefaultRouteStartupOrder;
import org.apache.camel.impl.engine.RouteService;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.RouteStartupOrder;
import org.apache.camel.support.OrderedComparator;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InternalRouteStartupManager {
    private static final Logger LOG = LoggerFactory.getLogger(InternalRouteStartupManager.class);
    private final ThreadLocal<Route> setupRoute = new ThreadLocal();
    private final AbstractCamelContext abstractCamelContext;
    private final CamelLogger routeLogger = new CamelLogger(LOG);

    public InternalRouteStartupManager(AbstractCamelContext abstractCamelContext) {
        this.abstractCamelContext = abstractCamelContext;
    }

    public Route getSetupRoute() {
        return this.setupRoute.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInitRoutes(Map<String, RouteService> routeServices) throws Exception {
        this.abstractCamelContext.setStartingRoutes(true);
        try {
            for (RouteService routeService : routeServices.values()) {
                StartupStep step = this.abstractCamelContext.getStartupStepRecorder().beginStep(Route.class, routeService.getId(), "Init Route");
                try {
                    LOG.debug("Initializing route id: {}", (Object)routeService.getId());
                    this.setupRoute.set(routeService.getRoute());
                    routeService.setUp();
                }
                finally {
                    this.setupRoute.remove();
                    this.abstractCamelContext.getStartupStepRecorder().endStep(step);
                }
            }
        }
        finally {
            this.abstractCamelContext.setStartingRoutes(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStartOrResumeRoutes(Map<String, RouteService> routeServices, boolean checkClash, boolean startConsumer, boolean resumeConsumer, boolean addingRoutes) throws Exception {
        this.abstractCamelContext.setStartingRoutes(true);
        try {
            LinkedHashMap<String, RouteService> filtered = new LinkedHashMap<String, RouteService>();
            for (Map.Entry<String, RouteService> entry : routeServices.entrySet()) {
                boolean startable = false;
                Consumer consumer = entry.getValue().getRoute().getConsumer();
                if (consumer instanceof SuspendableService) {
                    startable = ((SuspendableService)consumer).isSuspended();
                }
                if (!startable && consumer instanceof StatefulService) {
                    startable = ((StatefulService)consumer).getStatus().isStartable();
                } else if (!startable) {
                    startable = entry.getValue().getStatus().isStartable();
                }
                if (!startable) continue;
                filtered.put(entry.getKey(), entry.getValue());
            }
            this.safelyStartRouteServices(checkClash, startConsumer, resumeConsumer, addingRoutes, filtered.values());
        }
        finally {
            this.abstractCamelContext.setStartingRoutes(false);
        }
    }

    protected synchronized void safelyStartRouteServices(boolean checkClash, boolean startConsumer, boolean resumeConsumer, boolean addingRoutes, Collection<RouteService> routeServices) throws Exception {
        TreeMap<Integer, DefaultRouteStartupOrder> inputs = new TreeMap<Integer, DefaultRouteStartupOrder>();
        for (RouteService routeService : routeServices) {
            DefaultRouteStartupOrder order = this.doPrepareRouteToBeStarted(routeService);
            if (checkClash) {
                this.doCheckStartupOrderClash(order, inputs);
            }
            inputs.put(order.getStartupOrder(), order);
        }
        this.doWarmUpRoutes(inputs, startConsumer);
        this.abstractCamelContext.getStartupListeners().sort((Comparator<StartupListener>)OrderedComparator.get());
        for (StartupListener startup : this.abstractCamelContext.getStartupListeners()) {
            startup.onCamelContextStarted(this.abstractCamelContext.getCamelContextReference(), this.abstractCamelContext.isStarted());
        }
        ArrayList<StartupListener> backup = new ArrayList<StartupListener>(this.abstractCamelContext.getStartupListeners());
        this.abstractCamelContext.getStartupListeners().clear();
        if (startConsumer) {
            if (resumeConsumer) {
                this.doResumeRouteConsumers(inputs, addingRoutes);
            } else {
                this.doStartRouteConsumers(inputs, addingRoutes);
            }
        }
        this.abstractCamelContext.getStartupListeners().sort((Comparator<StartupListener>)OrderedComparator.get());
        for (StartupListener startup : this.abstractCamelContext.getStartupListeners()) {
            startup.onCamelContextStarted(this.abstractCamelContext.getCamelContextReference(), this.abstractCamelContext.isStarted());
        }
        this.abstractCamelContext.getStartupListeners().addAll(0, backup);
        inputs.clear();
    }

    protected synchronized void safelyStartRouteServices(boolean forceAutoStart, boolean checkClash, boolean startConsumer, boolean resumeConsumer, boolean addingRoutes, RouteService ... routeServices) throws Exception {
        this.safelyStartRouteServices(checkClash, startConsumer, resumeConsumer, addingRoutes, Arrays.asList(routeServices));
    }

    DefaultRouteStartupOrder doPrepareRouteToBeStarted(RouteService routeService) {
        Integer startupOrder = routeService.getRoute().getStartupOrder();
        if (startupOrder == null) {
            startupOrder = this.abstractCamelContext.defaultRouteStartupOrder++;
        }
        Route route = routeService.getRoute();
        return new DefaultRouteStartupOrder(startupOrder, route, routeService);
    }

    boolean doCheckStartupOrderClash(DefaultRouteStartupOrder answer, Map<Integer, DefaultRouteStartupOrder> inputs) throws FailedToStartRouteException {
        DefaultRouteStartupOrder other = inputs.get(answer.getStartupOrder());
        if (other != null && answer != other) {
            String otherId = other.getRoute().getId();
            throw new FailedToStartRouteException(answer.getRoute().getId(), "startupOrder clash. Route " + otherId + " already has startupOrder " + answer.getStartupOrder() + " configured which this route have as well. Please correct startupOrder to be unique among all your routes.");
        }
        for (RouteStartupOrder order : this.abstractCamelContext.getCamelContextExtension().getRouteStartupOrder()) {
            String otherId = order.getRoute().getId();
            if (answer.getRoute().getId().equals(otherId) || answer.getStartupOrder() != order.getStartupOrder()) continue;
            throw new FailedToStartRouteException(answer.getRoute().getId(), "startupOrder clash. Route " + otherId + " already has startupOrder " + answer.getStartupOrder() + " configured which this route have as well. Please correct startupOrder to be unique among all your routes.");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doWarmUpRoutes(Map<Integer, DefaultRouteStartupOrder> inputs, boolean autoStartup) throws FailedToStartRouteException {
        for (Map.Entry<Integer, DefaultRouteStartupOrder> entry : inputs.entrySet()) {
            RouteService routeService = entry.getValue().getRouteService();
            StartupStep step = this.abstractCamelContext.getStartupStepRecorder().beginStep(Route.class, routeService.getId(), "Warump Route");
            try {
                LOG.debug("Warming up route id: {} having autoStartup={}", (Object)routeService.getId(), (Object)autoStartup);
                this.setupRoute.set(routeService.getRoute());
                routeService.setUp();
                routeService.warmUp();
            }
            finally {
                this.setupRoute.remove();
                this.abstractCamelContext.getStartupStepRecorder().endStep(step);
            }
        }
    }

    void doResumeRouteConsumers(Map<Integer, DefaultRouteStartupOrder> inputs, boolean addingRoutes) throws Exception {
        this.doStartOrResumeRouteConsumers(inputs, true, addingRoutes);
    }

    void doStartRouteConsumers(Map<Integer, DefaultRouteStartupOrder> inputs, boolean addingRoutes) throws Exception {
        this.doStartOrResumeRouteConsumers(inputs, false, addingRoutes);
    }

    private LoggingLevel getRouteLoggerLogLevel() {
        return this.abstractCamelContext.getRouteController().getLoggingLevel();
    }

    private void doStartOrResumeRouteConsumers(Map<Integer, DefaultRouteStartupOrder> inputs, boolean resumeOnly, boolean addingRoute) throws Exception {
        ArrayList<Endpoint> routeInputs = new ArrayList<Endpoint>();
        for (Map.Entry<Integer, DefaultRouteStartupOrder> entry : inputs.entrySet()) {
            Integer order = entry.getKey();
            Route route = entry.getValue().getRoute();
            RouteService routeService = entry.getValue().getRouteService();
            boolean autoStartup = routeService.isAutoStartup();
            if (addingRoute && !autoStartup) {
                this.routeLogger.log("Skipping starting of route " + routeService.getId() + " as it's configured with autoStartup=false", this.getRouteLoggerLogLevel());
                continue;
            }
            StartupStep step = this.abstractCamelContext.getStartupStepRecorder().beginStep(Route.class, route.getRouteId(), "Start Route");
            Consumer consumer = routeService.getInput();
            if (consumer != null) {
                Endpoint endpoint = consumer.getEndpoint();
                if (!this.doCheckMultipleConsumerSupportClash(endpoint, routeInputs)) {
                    throw new FailedToStartRouteException(routeService.getId(), "Multiple consumers for the same endpoint is not allowed: " + endpoint);
                }
                ArrayList<Endpoint> existingEndpoints = new ArrayList<Endpoint>();
                for (Route existingRoute : this.abstractCamelContext.getRoutes()) {
                    if (route.getId().equals(existingRoute.getId())) continue;
                    Endpoint existing = existingRoute.getEndpoint();
                    ServiceStatus status = this.abstractCamelContext.getRouteStatus(existingRoute.getId());
                    if (status == null || !status.isStarted() && !status.isStarting()) continue;
                    existingEndpoints.add(existing);
                }
                if (!this.doCheckMultipleConsumerSupportClash(endpoint, existingEndpoints)) {
                    throw new FailedToStartRouteException(routeService.getId(), "Multiple consumers for the same endpoint is not allowed: " + endpoint);
                }
                LOG.debug("Route: {} >>> {}", (Object)route.getId(), (Object)route);
                if (resumeOnly) {
                    LOG.debug("Resuming consumer (order: {}) on route: {}", (Object)order, (Object)route.getId());
                } else {
                    LOG.debug("Starting consumer (order: {}) on route: {}", (Object)order, (Object)route.getId());
                }
                if (resumeOnly && route.supportsSuspension()) {
                    ServiceHelper.resumeService((Object)consumer);
                    uri = endpoint.getEndpointBaseUri();
                    uri = URISupport.sanitizeUri((String)uri);
                    this.routeLogger.log("Route: " + route.getId() + " resumed and consuming from: " + (String)uri, this.getRouteLoggerLogLevel());
                } else {
                    for (LifecycleStrategy strategy : this.abstractCamelContext.getLifecycleStrategies()) {
                        strategy.onServiceAdd(this.abstractCamelContext.getCamelContextReference(), (Service)consumer, route);
                    }
                    try {
                        this.abstractCamelContext.startService((Service)consumer);
                        route.getProperties().remove("route.start.exception");
                    }
                    catch (Exception e) {
                        route.getProperties().put("route.start.exception", e);
                        throw e;
                    }
                    uri = endpoint.getEndpointBaseUri();
                    uri = URISupport.sanitizeUri((String)uri);
                    this.routeLogger.log("Route: " + route.getId() + " started and consuming from: " + (String)uri, this.getRouteLoggerLogLevel());
                }
                routeInputs.add(endpoint);
                boolean found = false;
                for (RouteStartupOrder other : this.abstractCamelContext.getCamelContextExtension().getRouteStartupOrder()) {
                    if (!other.getRoute().getId().equals(route.getId())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.abstractCamelContext.getCamelContextExtension().getRouteStartupOrder().add((RouteStartupOrder)entry.getValue());
                }
            }
            if (resumeOnly) {
                routeService.resume();
            } else {
                try {
                    routeService.start();
                    route.getProperties().remove("route.start.exception");
                }
                catch (Exception e) {
                    route.getProperties().put("route.start.exception", e);
                    throw e;
                }
            }
            this.abstractCamelContext.getStartupStepRecorder().endStep(step);
        }
    }

    private boolean doCheckMultipleConsumerSupportClash(Endpoint endpoint, List<Endpoint> routeInputs) {
        boolean multipleConsumersSupported = false;
        if (endpoint instanceof MultipleConsumersSupport) {
            multipleConsumersSupported = ((MultipleConsumersSupport)endpoint).isMultipleConsumersSupported();
        }
        if (multipleConsumersSupported) {
            return true;
        }
        return !routeInputs.contains(endpoint);
    }
}

