/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.queue;

import com.azure.core.http.HttpHeaders;
import com.azure.storage.queue.models.QueueMessageItem;
import com.azure.storage.queue.models.QueuesSegmentOptions;
import com.azure.storage.queue.models.SendMessageResult;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.azure.storage.queue.QueueOperationDefinition;

public class QueueExchangeHeaders {
    private final Map<String, Object> headers = new HashMap<String, Object>();

    public static QueueExchangeHeaders createQueueExchangeHeadersFromSendMessageResult(SendMessageResult result) {
        return new QueueExchangeHeaders().messageId(result.getMessageId()).insertionTime(result.getInsertionTime()).expirationTime(result.getExpirationTime()).popReceipt(result.getPopReceipt()).timeNextVisible(result.getTimeNextVisible());
    }

    public static QueueExchangeHeaders createQueueExchangeHeadersFromQueueMessageItem(QueueMessageItem item) {
        return new QueueExchangeHeaders().messageId(item.getMessageId()).insertionTime(item.getInsertionTime()).expirationTime(item.getExpirationTime()).popReceipt(item.getPopReceipt()).timeNextVisible(item.getTimeNextVisible()).dequeueCount(item.getDequeueCount());
    }

    public Map<String, Object> toMap() {
        return this.headers;
    }

    public static QueuesSegmentOptions getQueuesSegmentOptionsFromHeaders(Exchange exchange) {
        return QueueExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageQueueSegmentOptions", QueuesSegmentOptions.class);
    }

    public static Duration getTimeoutFromHeaders(Exchange exchange) {
        return QueueExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageQueueTimeout", Duration.class);
    }

    public static Map<String, String> getMetadataFromHeaders(Exchange exchange) {
        return QueueExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageQueueMetadata", Map.class);
    }

    public static Duration getTimeToLiveFromHeaders(Exchange exchange) {
        return QueueExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageQueueTimeToLive", Duration.class);
    }

    public static Duration getVisibilityTimeout(Exchange exchange) {
        return QueueExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageQueueVisibilityTimeout", Duration.class);
    }

    public static Boolean getCreateQueueFlagFromHeaders(Exchange exchange) {
        return QueueExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageQueueCreateQueue", Boolean.class);
    }

    public static String getPopReceiptFromHeaders(Exchange exchange) {
        return QueueExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageQueuePopReceipt", String.class);
    }

    public static String getMessageIdFromHeaders(Exchange exchange) {
        return QueueExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageQueueMessageId", String.class);
    }

    public static Integer getMaxMessagesFromHeaders(Exchange exchange) {
        return QueueExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageQueueMaxMessages", Integer.class);
    }

    public static QueueOperationDefinition getQueueOperationsDefinitionFromHeaders(Exchange exchange) {
        return QueueExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageQueueOperation", QueueOperationDefinition.class);
    }

    public static String getQueueNameFromHeaders(Exchange exchange) {
        return QueueExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageQueueName", String.class);
    }

    private static <T> T getObjectFromHeaders(Exchange exchange, String headerName, Class<T> classType) {
        return (T)exchange.getIn().getHeader(headerName, classType);
    }

    public QueueExchangeHeaders messageId(String id) {
        this.headers.put("CamelAzureStorageQueueMessageId", id);
        return this;
    }

    public QueueExchangeHeaders insertionTime(OffsetDateTime insertionTime) {
        this.headers.put("CamelAzureStorageQueueInsertionTime", insertionTime);
        if (insertionTime != null) {
            long ts = insertionTime.toEpochSecond() * 1000L;
            this.headers.put("CamelMessageTimestamp", ts);
        }
        return this;
    }

    public QueueExchangeHeaders expirationTime(OffsetDateTime expirationTime) {
        this.headers.put("CamelAzureStorageQueueExpirationTime", expirationTime);
        return this;
    }

    public QueueExchangeHeaders popReceipt(String pop) {
        this.headers.put("CamelAzureStorageQueuePopReceipt", pop);
        return this;
    }

    public QueueExchangeHeaders timeNextVisible(OffsetDateTime timeNextVisible) {
        this.headers.put("CamelAzureStorageQueueTimeNextVisible", timeNextVisible);
        return this;
    }

    public QueueExchangeHeaders dequeueCount(long count) {
        this.headers.put("CamelAzureStorageQueueDequeueCount", count);
        return this;
    }

    public QueueExchangeHeaders httpHeaders(HttpHeaders httpHeaders) {
        this.headers.put("CamelAzureStorageQueueRawHttpHeaders", httpHeaders);
        return this;
    }
}

