/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.queue.operations;

import com.azure.core.http.rest.Response;
import com.azure.storage.queue.models.SendMessageResult;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.component.azure.storage.queue.QueueExchangeHeaders;

public final class QueueOperationResponse {
    private Object body;
    private Map<String, Object> headers = new HashMap<String, Object>();

    public QueueOperationResponse(Object body, Map<String, Object> headers) {
        this.body = body;
        this.headers = headers;
    }

    private QueueOperationResponse(Object body) {
        this.setBody(body);
    }

    public static QueueOperationResponse create(Object body) {
        return new QueueOperationResponse(body);
    }

    public static QueueOperationResponse create(Object body, Map<String, Object> headers) {
        return new QueueOperationResponse(body, headers);
    }

    public static QueueOperationResponse create(Response response) {
        return QueueOperationResponse.buildResponse(response, false);
    }

    public static QueueOperationResponse createWithEmptyBody(Map<String, Object> headers) {
        return new QueueOperationResponse(true, headers);
    }

    public static QueueOperationResponse createWithEmptyBody(Response response) {
        return QueueOperationResponse.buildResponse(response, true);
    }

    private static QueueOperationResponse buildResponse(Response response, boolean emptyBody) {
        Object body = emptyBody ? Boolean.valueOf(true) : response.getValue();
        QueueExchangeHeaders exchangeHeaders = response.getValue() instanceof SendMessageResult ? QueueExchangeHeaders.createQueueExchangeHeadersFromSendMessageResult((SendMessageResult)response.getValue()) : new QueueExchangeHeaders();
        exchangeHeaders.httpHeaders(response.getHeaders());
        return new QueueOperationResponse(body, exchangeHeaders.toMap());
    }

    public Object getBody() {
        return this.body;
    }

    private void setBody(Object body) {
        this.body = body;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }
}

