/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.mq;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.mq.AmazonMQ;
import com.amazonaws.services.mq.AmazonMQClient;
import com.amazonaws.services.mq.AmazonMQClientBuilder;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws.mq.MQConfiguration;
import org.apache.camel.component.aws.mq.MQProducer;
import org.apache.camel.impl.ScheduledPollEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="2.21.0", scheme="aws-mq", title="AWS MQ", syntax="aws-mq:label", producerOnly=true, label="cloud,management")
public class MQEndpoint
extends ScheduledPollEndpoint {
    private AmazonMQ mqClient;
    @UriParam
    private MQConfiguration configuration;

    public MQEndpoint(String uri, Component component, MQConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new MQProducer((Endpoint)this);
    }

    public boolean isSingleton() {
        return true;
    }

    public void doStart() throws Exception {
        super.doStart();
        this.mqClient = this.configuration.getAmazonMqClient() != null ? this.configuration.getAmazonMqClient() : (AmazonMQClient)this.createMQClient();
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getAmazonMqClient()) && this.mqClient != null) {
            this.mqClient.shutdown();
        }
        super.doStop();
    }

    public MQConfiguration getConfiguration() {
        return this.configuration;
    }

    public AmazonMQ getAmazonMqClient() {
        return this.mqClient;
    }

    AmazonMQ createMQClient() {
        AmazonMQ client = null;
        ClientConfiguration clientConfiguration = null;
        AmazonMQClientBuilder clientBuilder = null;
        boolean isClientConfigFound = false;
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            clientConfiguration = new ClientConfiguration();
            clientConfiguration.setProxyHost(this.configuration.getProxyHost());
            clientConfiguration.setProxyPort(this.configuration.getProxyPort().intValue());
            isClientConfigFound = true;
        }
        if (this.configuration.getAccessKey() != null && this.configuration.getSecretKey() != null) {
            BasicAWSCredentials credentials = new BasicAWSCredentials(this.configuration.getAccessKey(), this.configuration.getSecretKey());
            AWSStaticCredentialsProvider credentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)credentials);
            clientBuilder = isClientConfigFound ? (AmazonMQClientBuilder)((AmazonMQClientBuilder)AmazonMQClientBuilder.standard().withClientConfiguration(clientConfiguration)).withCredentials((AWSCredentialsProvider)credentialsProvider) : (AmazonMQClientBuilder)AmazonMQClientBuilder.standard().withCredentials((AWSCredentialsProvider)credentialsProvider);
        } else {
            clientBuilder = isClientConfigFound ? AmazonMQClientBuilder.standard() : (AmazonMQClientBuilder)AmazonMQClientBuilder.standard().withClientConfiguration(clientConfiguration);
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getRegion())) {
            clientBuilder = (AmazonMQClientBuilder)clientBuilder.withRegion(this.configuration.getRegion());
        }
        client = (AmazonMQ)clientBuilder.build();
        return client;
    }
}

