/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ddb;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.aws.ddb.AbstractDdbCommand;
import org.apache.camel.component.aws.ddb.DdbConfiguration;

public class ScanCommand
extends AbstractDdbCommand {
    public ScanCommand(AmazonDynamoDB ddbClient, DdbConfiguration configuration, Exchange exchange) {
        super(ddbClient, configuration, exchange);
    }

    @Override
    public void execute() {
        ScanResult result = this.ddbClient.scan(new ScanRequest().withTableName(this.determineTableName()).withScanFilter(this.determineScanFilter()));
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        tmp.put("CamelAwsDdbItems", result.getItems());
        tmp.put("CamelAwsDdbLastEvaluatedKey", result.getLastEvaluatedKey());
        tmp.put("CamelAwsDdbConsumedCapacity", result.getConsumedCapacity());
        tmp.put("CamelAwsDdbCount", result.getCount());
        tmp.put("CamelAwsDdbScannedCount", result.getScannedCount());
        this.addToResults(tmp);
    }

    private Map<String, Condition> determineScanFilter() {
        return (Map)this.exchange.getIn().getHeader("CamelAwsDdbScanFilter", Map.class);
    }
}

