/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atom;

import java.util.Date;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.atom.AtomComponent;
import org.apache.camel.component.atom.AtomEntryPollingConsumer;
import org.apache.camel.component.atom.AtomPollingConsumer;
import org.apache.camel.impl.DefaultPollingEndpoint;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomEndpoint
extends DefaultPollingEndpoint<Exchange> {
    public static final String HEADER_ATOM_FEED = "org.apache.camel.component.atom.feed";
    private String atomUri;
    private boolean splitEntries = true;
    private Date lastUpdate;
    private boolean filter = true;

    public AtomEndpoint(String endpointUri, AtomComponent component, String atomUri) {
        super(endpointUri, (Component)component);
        this.atomUri = atomUri;
        ObjectHelper.notNull((Object)atomUri, (String)"atomUri property");
    }

    public AtomEndpoint(String endpointUri, String atomUri) {
        this(endpointUri);
        this.atomUri = atomUri;
        ObjectHelper.notNull((Object)atomUri, (String)"atomUri property");
    }

    public AtomEndpoint(String endpointUri) {
        super(endpointUri);
    }

    public boolean isSingleton() {
        return true;
    }

    public Producer<Exchange> createProducer() throws Exception {
        throw new UnsupportedOperationException("AtomProducer is not implemented");
    }

    public Consumer<Exchange> createConsumer(Processor processor) throws Exception {
        AtomPollingConsumer answer = this.isSplitEntries() ? new AtomEntryPollingConsumer(this, processor, this.filter, this.lastUpdate) : new AtomPollingConsumer(this, processor);
        answer.setDelay(60000L);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public Exchange createExchange(Feed feed) {
        Exchange exchange = this.createExchange();
        exchange.getIn().setBody((Object)feed.getEntries());
        exchange.getIn().setHeader(HEADER_ATOM_FEED, (Object)feed);
        return exchange;
    }

    public Exchange createExchange(Feed feed, Entry entry) {
        Exchange exchange = this.createExchange();
        exchange.getIn().setBody((Object)entry);
        exchange.getIn().setHeader(HEADER_ATOM_FEED, (Object)feed);
        return exchange;
    }

    public String getAtomUri() {
        return this.atomUri;
    }

    public void setAtomUri(String atomUri) {
        this.atomUri = atomUri;
    }

    public boolean isSplitEntries() {
        return this.splitEntries;
    }

    public void setSplitEntries(boolean splitEntries) {
        this.splitEntries = splitEntries;
    }

    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public boolean isFilter() {
        return this.filter;
    }

    public void setFilter(boolean filter) {
        this.filter = filter;
    }
}

