/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api.entity;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.as2.api.CanonicalOutputStream;
import org.apache.camel.component.as2.api.entity.MimeEntity;
import org.apache.camel.component.as2.api.util.EntityUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.slf4j.helpers.MessageFormatter;

public abstract class ApplicationEntity
extends MimeEntity {
    protected static final String CONTENT_DISPOSITION_PATTERN = "attachment; filename={}";
    protected final byte[] ediContent;

    protected ApplicationEntity(byte[] ediContent, ContentType contentType, String contentTransferEncoding, boolean isMainBody, String filename) {
        super(contentType, contentTransferEncoding);
        this.ediContent = (byte[])ObjectHelper.notNull((Object)ediContent, (String)"EDI Content");
        this.setMainBody(isMainBody);
        if (StringUtils.isNotBlank((CharSequence)filename)) {
            this.addHeader("Content-Disposition", MessageFormatter.format((String)CONTENT_DISPOSITION_PATTERN, (Object)filename).getMessage());
        }
    }

    public Object getEdiMessage() {
        if (this.getContentEncoding() != null) {
            switch (this.getContentEncoding().toLowerCase()) {
                case "base64": 
                case "binary": {
                    return new ByteArrayInputStream(this.ediContent);
                }
            }
        }
        try {
            return new String(this.ediContent, this.getCharset());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public void writeTo(OutputStream outstream) throws IOException {
        MimeEntity.NoCloseOutputStream ncos = new MimeEntity.NoCloseOutputStream(outstream);
        try (CanonicalOutputStream canonicalOutstream = new CanonicalOutputStream(ncos, StandardCharsets.US_ASCII.name());
             OutputStream transferEncodedStream = EntityUtils.encode(ncos, this.getContentTransferEncodingValue());){
            if (!this.isMainBody()) {
                for (Header header : this.getAllHeaders()) {
                    canonicalOutstream.writeln(header.toString());
                }
                canonicalOutstream.writeln();
            }
            transferEncodedStream.write(this.ediContent);
        }
        catch (Exception e) {
            throw new IOException("Failed to write to output stream", e);
        }
    }
}

