/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.component.as2.api.InvalidAS2NameException;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.message.RequestLine;
import org.apache.hc.core5.http.message.StatusLine;

public final class AS2Utils {
    public static final String DQUOTE = "\"";
    public static final String BACKSLASH = "\\\\";
    public static final String AS2_TEXT_CHAR_SET = "[!#-\\[\\]-~]";
    public static final String AS2_QUOTED_TEXT_CHAR_SET = "[ !#-\\[\\]-~]";
    public static final String AS2_QUOTED_PAIR = "\\\\\"|\\\\\\\\";
    public static final String AS2_QUOTED_NAME = "\"([ !#-\\[\\]-~]|\\\\\"|\\\\\\\\){1,128}\"";
    public static final String AS2_ATOMIC_NAME = "([!#-\\[\\]-~]){1,128}";
    public static final String AS2_NAME = "([!#-\\[\\]-~]){1,128}|\"([ !#-\\[\\]-~]|\\\\\"|\\\\\\\\){1,128}\"";
    public static final Pattern AS_NAME_PATTERN = Pattern.compile("([!#-\\[\\]-~]){1,128}|\"([ !#-\\[\\]-~]|\\\\\"|\\\\\\\\){1,128}\"");
    private static SecureRandom generator = new SecureRandom();

    private AS2Utils() {
    }

    public static void validateAS2Name(String name) throws InvalidAS2NameException {
        Matcher matcher = AS_NAME_PATTERN.matcher(name);
        if (!matcher.matches()) {
            Matcher region;
            int i;
            for (i = name.length() - 1; i > 0 && !(region = matcher.region(0, i)).matches() && !region.hitEnd(); --i) {
            }
            throw new InvalidAS2NameException(name, i);
        }
    }

    public static String createMessageId(String fqdn) {
        return "<" + Long.toString(System.nanoTime(), 36) + "." + Long.toString(generator.nextLong(), 36) + "@" + fqdn + ">";
    }

    public static boolean isPrintableChar(char c) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        return !Character.isISOControl(c) && c != '\uffff' && block != null && block != Character.UnicodeBlock.SPECIALS;
    }

    public static String printRequest(HttpRequest request) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            PrintStream ps = new PrintStream((OutputStream)baos, true, "utf-8");
            try {
                AS2Utils.printRequest(ps, request);
                String string = baos.toString(StandardCharsets.UTF_8.name());
                ps.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    ps.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public static String printMessage(HttpMessage message) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            PrintStream ps = new PrintStream((OutputStream)baos, true, "utf-8");
            try {
                AS2Utils.printMessage(ps, message);
                String string = baos.toString(StandardCharsets.UTF_8.name());
                ps.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    ps.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public static void printRequest(PrintStream out, HttpRequest request) throws IOException {
        out.println(new RequestLine(request));
        Iterator it = request.headerIterator();
        while (it.hasNext()) {
            Header header = (Header)it.next();
            out.println(header.getName() + ": " + (header.getValue() == null ? "" : header.getValue()));
        }
        out.println();
        if (request instanceof BasicClassicHttpRequest) {
            HttpEntity entity = ((BasicClassicHttpRequest)request).getEntity();
            entity.writeTo((OutputStream)out);
        }
    }

    public static void printMessage(PrintStream out, HttpMessage message) throws IOException {
        HttpEntity entity;
        if (message instanceof HttpRequest) {
            out.println(new RequestLine((HttpRequest)message));
        } else {
            out.println(new StatusLine((HttpResponse)message));
        }
        Iterator it = message.headerIterator();
        while (it.hasNext()) {
            Header header = (Header)it.next();
            out.println(header.getName() + ": " + (header.getValue() == null ? "" : header.getValue()));
        }
        out.println();
        if (message instanceof BasicClassicHttpRequest) {
            entity = ((BasicClassicHttpRequest)message).getEntity();
            if (entity != null) {
                entity.writeTo((OutputStream)out);
            }
        } else if (message instanceof BasicClassicHttpResponse && (entity = ((BasicClassicHttpResponse)message).getEntity()) != null) {
            entity.writeTo((OutputStream)out);
        }
    }
}

