/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api;

import java.io.IOException;
import java.net.Socket;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.camel.component.as2.api.io.AS2BHttpClientConnection;
import org.apache.camel.component.as2.api.protocol.RequestAS2;
import org.apache.camel.component.as2.api.protocol.RequestMDN;
import org.apache.camel.util.ObjectHelper;
import org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.impl.io.ManagedHttpClientConnectionFactory;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.ConnectionEndpoint;
import org.apache.hc.client5.http.io.LeaseRequest;
import org.apache.hc.client5.http.io.ManagedHttpClientConnection;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HeaderElement;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.impl.io.HttpRequestExecutor;
import org.apache.hc.core5.http.io.HttpClientConnection;
import org.apache.hc.core5.http.io.HttpConnectionFactory;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.message.MessageSupport;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http.protocol.HttpProcessorBuilder;
import org.apache.hc.core5.http.protocol.RequestConnControl;
import org.apache.hc.core5.http.protocol.RequestContent;
import org.apache.hc.core5.http.protocol.RequestDate;
import org.apache.hc.core5.http.protocol.RequestExpectContinue;
import org.apache.hc.core5.http.protocol.RequestTargetHost;
import org.apache.hc.core5.http.protocol.RequestUserAgent;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

public class AS2ClientConnection {
    private static final int RETRIEVE_CONNECTION_TIMEOUT_SECONDS = 5;
    private HttpHost targetHost;
    private HttpProcessor httpProcessor;
    private String as2Version;
    private String userAgent;
    private String clientFqdn;
    private int connectionTimeoutMilliseconds;
    private PoolingHttpClientConnectionManager connectionPoolManager;
    private ConnectionKeepAliveStrategy connectionKeepAliveStrategy;

    public AS2ClientConnection(String as2Version, String userAgent, String clientFqdn, String targetHostName, Integer targetPortNumber, Duration socketTimeout, Duration connectionTimeout, Integer connectionPoolMaxSize, Duration connectionPoolTtl, SSLContext sslContext, HostnameVerifier hostnameVerifier) throws IOException {
        this.as2Version = (String)ObjectHelper.notNull((Object)as2Version, (String)"as2Version");
        this.userAgent = (String)ObjectHelper.notNull((Object)userAgent, (String)"userAgent");
        this.clientFqdn = (String)ObjectHelper.notNull((Object)clientFqdn, (String)"clientFqdn");
        this.targetHost = new HttpHost(sslContext != null ? "https" : "http", (String)ObjectHelper.notNull((Object)targetHostName, (String)"targetHostName"), ((Integer)ObjectHelper.notNull((Object)targetPortNumber, (String)"targetPortNumber")).intValue());
        ObjectHelper.notNull((Object)socketTimeout, (String)"socketTimeout");
        this.connectionTimeoutMilliseconds = (int)((Duration)ObjectHelper.notNull((Object)connectionTimeout, (String)"connectionTimeout")).toMillis();
        ObjectHelper.notNull((Object)connectionPoolMaxSize, (String)"connectionPoolMaxSize");
        ObjectHelper.notNull((Object)connectionPoolTtl, (String)"connectionPoolTtl");
        this.httpProcessor = HttpProcessorBuilder.create().add((HttpRequestInterceptor)new RequestAS2(as2Version, clientFqdn)).add((HttpRequestInterceptor)new RequestMDN()).add((HttpRequestInterceptor)new RequestTargetHost()).add((HttpRequestInterceptor)new RequestUserAgent(this.userAgent)).add((HttpRequestInterceptor)new RequestDate()).add((HttpRequestInterceptor)new RequestContent(true)).add((HttpRequestInterceptor)new RequestConnControl()).add((HttpRequestInterceptor)new RequestExpectContinue()).build();
        Http1Config h1Config = Http1Config.custom().setBufferSize(8192).build();
        ManagedHttpClientConnectionFactory connFactory = new ManagedHttpClientConnectionFactory(h1Config, null, null){

            public ManagedHttpClientConnection createConnection(Socket socket) throws IOException {
                ManagedHttpClientConnection mc = super.createConnection(socket);
                return new AS2BHttpClientConnection(mc);
            }
        };
        if (sslContext == null) {
            this.connectionPoolManager = PoolingHttpClientConnectionManagerBuilder.create().setConnectionFactory((HttpConnectionFactory)connFactory).build();
        } else {
            SSLConnectionSocketFactory sslConnectionSocketFactory = hostnameVerifier == null ? new SSLConnectionSocketFactory(sslContext) : new SSLConnectionSocketFactory(sslContext, hostnameVerifier);
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslConnectionSocketFactory).build();
            this.connectionPoolManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry, (HttpConnectionFactory)connFactory);
        }
        this.connectionPoolManager.setMaxTotal(connectionPoolMaxSize.intValue());
        this.connectionPoolManager.setDefaultSocketConfig(SocketConfig.copy((SocketConfig)SocketConfig.DEFAULT).setSoTimeout(Timeout.ofSeconds((long)socketTimeout.getSeconds())).build());
        this.connectionPoolManager.setDefaultConnectionConfig(ConnectionConfig.custom().setConnectTimeout(Timeout.ofMilliseconds((long)this.connectionTimeoutMilliseconds)).build());
        this.connectionKeepAliveStrategy = (response, context) -> {
            TimeValue ttl = TimeValue.of((Duration)connectionPoolTtl);
            for (Header h : response.getHeaders()) {
                HeaderElement headerElement;
                if ("Connection".equalsIgnoreCase(h.getName()) && "Close".equalsIgnoreCase(h.getValue())) {
                    ttl = TimeValue.NEG_ONE_MILLISECOND;
                }
                if (!"Keep-Alive".equalsIgnoreCase(h.getName()) || (headerElement = MessageSupport.parse((Header)h)[0]).getValue() == null || !"timeout".equalsIgnoreCase(headerElement.getName())) continue;
                ttl = TimeValue.ofSeconds((long)Long.parseLong(headerElement.getValue()));
            }
            return ttl;
        };
        this.createTestConnection(sslContext, (HttpConnectionFactory<ManagedHttpClientConnection>)connFactory).close();
    }

    public String getAs2Version() {
        return this.as2Version;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getClientFqdn() {
        return this.clientFqdn;
    }

    public HttpResponse send(ClassicHttpRequest request, HttpCoreContext httpContext) throws HttpException, IOException, InterruptedException, ExecutionException, TimeoutException {
        HttpRoute route = new HttpRoute(this.targetHost);
        request.setAuthority(new URIAuthority((NamedEndpoint)this.targetHost));
        LeaseRequest leaseRequest = this.connectionPoolManager.lease(UUID.randomUUID().toString(), route, null);
        ConnectionEndpoint endpoint = leaseRequest.get(Timeout.ofSeconds((long)5L));
        if (!endpoint.isConnected()) {
            this.connectionPoolManager.connect(endpoint, TimeValue.ofMilliseconds((long)this.connectionTimeoutMilliseconds), (HttpContext)httpContext);
        }
        HttpRequestExecutor httpExecutor = new HttpRequestExecutor(){

            public ClassicHttpResponse execute(ClassicHttpRequest request, HttpClientConnection conn, HttpContext context) throws IOException, HttpException {
                super.preProcess(request, AS2ClientConnection.this.httpProcessor, context);
                ClassicHttpResponse response = super.execute(request, conn, context);
                super.postProcess(response, AS2ClientConnection.this.httpProcessor, context);
                return response;
            }
        };
        ClassicHttpResponse response = endpoint.execute(UUID.randomUUID().toString(), request, httpExecutor, (HttpContext)httpContext);
        this.connectionPoolManager.release(endpoint, null, this.connectionKeepAliveStrategy.getKeepAliveDuration((HttpResponse)response, (HttpContext)httpContext));
        return response;
    }

    private HttpConnection createTestConnection(SSLContext sslContext, HttpConnectionFactory<ManagedHttpClientConnection> connFactory) throws IOException {
        if (sslContext == null) {
            return connFactory.createConnection(new Socket(this.targetHost.getHostName(), this.targetHost.getPort()));
        }
        SSLSocketFactory factory = sslContext.getSocketFactory();
        return connFactory.createConnection(factory.createSocket(this.targetHost.getHostName(), this.targetHost.getPort()));
    }
}

