/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.apache.camel.util.ObjectHelper;

public class ObjectHelperTest
extends TestCase {
    public void testRemoveInitialCharacters() throws Exception {
        ObjectHelperTest.assertEquals((String)ObjectHelper.removeStartingCharacters("foo", '/'), (String)"foo");
        ObjectHelperTest.assertEquals((String)ObjectHelper.removeStartingCharacters("/foo", '/'), (String)"foo");
        ObjectHelperTest.assertEquals((String)ObjectHelper.removeStartingCharacters("//foo", '/'), (String)"foo");
    }

    public void testGetPropertyName() throws Exception {
        Method method = ((Object)((Object)this)).getClass().getMethod("setCheese", String.class);
        ObjectHelperTest.assertNotNull((String)"should have found a method!", (Object)method);
        String name = ObjectHelper.getPropertyName(method);
        ObjectHelperTest.assertEquals((String)"Property name", (String)"cheese", (String)name);
    }

    public void setCheese(String cheese) {
    }

    public void testContains() throws Exception {
        String[] array = new String[]{"foo", "bar"};
        List<String> collection = Arrays.asList(array);
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.contains(array, "foo"));
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.contains(collection, "foo"));
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.contains("foo", "foo"));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.contains(array, "xyz"));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.contains(collection, "xyz"));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.contains("foo", "xyz"));
    }

    public void testEqual() {
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.equal(null, null));
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.equal("", ""));
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.equal(" ", " "));
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.equal("Hello", "Hello"));
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.equal(123, 123));
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.equal(true, true));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.equal(null, ""));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.equal("", null));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.equal(" ", "    "));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.equal("Hello", "World"));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.equal(true, false));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.equal(new Object(), new Object()));
        byte[] a = new byte[]{40, 50, 60};
        byte[] b = new byte[]{40, 50, 60};
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.equal(a, b));
        a = new byte[]{40, 50, 60};
        b = new byte[]{40, 50, 60, 70};
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.equal(a, b));
    }

    public void testEqualByteArray() {
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.equalByteArray("Hello".getBytes(), "Hello".getBytes()));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.equalByteArray("Hello".getBytes(), "World".getBytes()));
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.equalByteArray("Hello Thai Elephant \u0e08".getBytes(), "Hello Thai Elephant \u0e08".getBytes()));
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.equalByteArray(null, null));
        byte[] empty = new byte[]{};
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.equalByteArray(empty, empty));
        byte[] a = new byte[]{40, 50, 60};
        byte[] b = new byte[]{40, 50, 60};
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.equalByteArray(a, b));
        a = new byte[]{40, 50, 60};
        b = new byte[]{40, 50, 60, 70};
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.equalByteArray(a, b));
        a = new byte[]{40, 50, 60, 70};
        b = new byte[]{40, 50, 60};
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.equalByteArray(a, b));
        a = new byte[]{40, 50, 60};
        b = new byte[]{};
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.equalByteArray(a, b));
        a = new byte[]{};
        b = new byte[]{40, 50, 60};
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.equalByteArray(a, b));
        a = new byte[]{40, 50, 60};
        b = null;
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.equalByteArray(a, b));
        a = null;
        b = new byte[]{40, 50, 60};
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.equalByteArray(a, b));
        a = null;
        b = null;
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.equalByteArray(a, b));
    }
}

