/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.component.event.EventComponent;
import org.apache.camel.component.event.EventEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.ProcessorEndpoint;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.Registry;
import org.apache.camel.spring.spi.ApplicationContextRegistry;
import org.apache.camel.spring.spi.SpringInjector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringCamelContext
extends DefaultCamelContext
implements InitializingBean,
DisposableBean,
ApplicationContextAware,
ApplicationListener {
    private static final transient Log LOG = LogFactory.getLog(SpringCamelContext.class);
    private ApplicationContext applicationContext;
    private EventEndpoint eventEndpoint;

    public SpringCamelContext() {
    }

    public SpringCamelContext(ApplicationContext applicationContext) {
        this.setApplicationContext(applicationContext);
    }

    public static SpringCamelContext springCamelContext(ApplicationContext applicationContext) throws Exception {
        String[] names = applicationContext.getBeanNamesForType(SpringCamelContext.class);
        if (names.length == 1) {
            return (SpringCamelContext)applicationContext.getBean(names[0], SpringCamelContext.class);
        }
        SpringCamelContext answer = new SpringCamelContext();
        answer.setApplicationContext(applicationContext);
        answer.afterPropertiesSet();
        return answer;
    }

    public static SpringCamelContext springCamelContext(String configLocations) throws Exception {
        return SpringCamelContext.springCamelContext((ApplicationContext)new ClassPathXmlApplicationContext(configLocations));
    }

    public void afterPropertiesSet() throws Exception {
        this.start();
    }

    public void destroy() throws Exception {
        this.stop();
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Publishing event: " + event));
        }
        if (event instanceof ContextRefreshedEvent) {
            try {
                LOG.debug((Object)"Starting the CamelContext now that the ApplicationContext has started");
                this.start();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeCamelException(e);
            }
            if (this.eventEndpoint != null) {
                this.eventEndpoint.onApplicationEvent(event);
            }
        } else if (this.eventEndpoint != null) {
            this.eventEndpoint.onApplicationEvent(event);
        } else {
            LOG.warn((Object)("No eventEndpoint enabled for event: " + event));
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        if (applicationContext instanceof ConfigurableApplicationContext) {
            this.addComponent("event", new EventComponent(applicationContext));
        }
    }

    public EventEndpoint getEventEndpoint() {
        return this.eventEndpoint;
    }

    public void setEventEndpoint(EventEndpoint eventEndpoint) {
        this.eventEndpoint = eventEndpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.eventEndpoint == null) {
            this.eventEndpoint = this.createEventEndpoint();
        }
    }

    protected Injector createInjector() {
        if (this.applicationContext instanceof ConfigurableApplicationContext) {
            return new SpringInjector((ConfigurableApplicationContext)this.applicationContext);
        }
        LOG.warn((Object)("Cannot use SpringInjector as applicationContext is not a ConfigurableApplicationContext as its: " + this.applicationContext));
        return super.createInjector();
    }

    protected EventEndpoint createEventEndpoint() {
        EventEndpoint endpoint = this.getEndpoint("event:default", EventEndpoint.class);
        return endpoint;
    }

    protected Endpoint convertBeanToEndpoint(String uri, Object bean) {
        BeanProcessor processor = new BeanProcessor(bean, this);
        return new ProcessorEndpoint(uri, this, (Processor)processor);
    }

    protected Registry createRegistry() {
        return new ApplicationContextRegistry(this.getApplicationContext());
    }
}

